﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_ParameterListItem.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
ParameterListItem::ParameterListItem()
 : m_ValueLoop( true )
{
    SetIsFocusable( true );
    SetMargin( nw::internal::dw::Thickness(0.f) );
    SetPadding( nw::internal::dw::Thickness(1.f, 0.f) );

    m_Container.GetContents().AddItem( &m_Label );
    m_Container.GetContents().AddItem( &m_ValueText );

    m_Label.SetMargin( nw::internal::dw::Thickness(2.f, 0.f) );
    m_Label.SetDock( nw::internal::dw::DOCK_LEFT );

    m_ValueText.SetMargin( nw::internal::dw::Thickness(2.f, 0.f) );

    m_Contents.AddItem( &m_Container );
    SetContents( m_Contents );
}

//---------------------------------------------------------------------------
const char*
ParameterListItem::GetLabelText() const
{
    return m_Label.GetText();
}

//---------------------------------------------------------------------------
void
ParameterListItem::SetLabelText(const char* value)
{
    m_Label.SetText(value);
}

//---------------------------------------------------------------------------
void
ParameterListItem::SetLabelWidth(f32 value)
{
    m_Label.SetMinimumWidth(value);
}

//---------------------------------------------------------------------------
bool
ParameterListItem::OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs)
{
    if(inputs.GetPad() == NULL)
    {
        return false;
    }

    const nw::dev::Pad& pad = *inputs.GetPad();

    if( pad.IsTrig(nw::dev::Pad::MASK_RIGHT) || pad.IsRepeatAccel(nw::dev::Pad::MASK_RIGHT) )
    {
        bool isLargeChange = pad.IsHold(nw::dev::Pad::MASK_L);
        NextValue(isLargeChange);

        return true;
    }

    if( pad.IsTrig(nw::dev::Pad::MASK_LEFT) || pad.IsRepeatAccel(nw::dev::Pad::MASK_LEFT) )
    {
        bool isLargeChange = pad.IsHold(nw::dev::Pad::MASK_L);
        PreviousValue(isLargeChange);

        return true;
    }

    return false;
}

//---------------------------------------------------------------------------
void
ParameterListItem::OnPrepareMeasure()
{
    if( !IsAvailable() )
    {
        m_ValueText.SetText("[N/A]");
        return;
    }

    static const u32 VALUETEXT_LENGTH = 256;
    char valueText[VALUETEXT_LENGTH];

    PrintValue( valueText, VALUETEXT_LENGTH );
    m_ValueText.SetText( valueText );
}

} /* namespace dw */
} /* namespace internal */
} /* namespace nw */
