﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/dw/control/dw_FileBrowserEntry.h>

namespace nw {
namespace internal {
namespace dw {

FileBrowserEntry::FileBrowserEntry()
{
    SetContents(m_Contents);
    SetMargin(Thickness(0.f));
    SetIsFocusable(true);

    m_Contents.AddItem(&m_Label);

    m_Label.SetMargin(Thickness(0.f));
    m_Label.SetPadding(Thickness(2.f, 0.f));
}

FileBrowserEntry::~FileBrowserEntry()
{
}

bool FileBrowserEntry::GetIsDirectory()
{
    return m_IsDirectory;
}

void FileBrowserEntry::SetIsDirectory(bool value)
{
    m_IsDirectory = value;
}

const char* FileBrowserEntry::GetText()
{
    return m_Label.GetText();
}

void FileBrowserEntry::SetText(const char* value)
{
    m_Label.SetText(value);
}

} // dw
} // internal
} // nw
