﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/modules/sndspy_TimeModule.h>
#include <nw/snd/spy/sndspy_SpyData.h>
#include <nw/snd/spy/sndspy_SpyController.h>
#include <nw/snd/spy/fnd/basis/sndspyfnd_Time.h>
#include <nw/snd/spy/fnd/binary/sndspyfnd_Binary.h>
#include <nw/snd/spy/fnd/string/sndspyfnd_String.h>

namespace {

//! @briefprivate
struct TimePacketData
{
    static const u32 VERSION = NW_SND_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 1, 0, 0);

    u32 spyFrame;
    u32 appFrame;
    u32 audioFrame;
};

} // namespace

namespace nw {
namespace snd {
namespace spy {

//----------------------------------------------------------
TimeModule::TimeModule()
    : SpySimpleModule("Time", TimePacketData::VERSION)
    , m_SpyFrameBase(0)
    , m_CurrentAppFrame(0)
    , m_CurrentAudioFrame(0)
{
}

//----------------------------------------------------------
u32
TimeModule::GetCurrentSpyFrame() const
{
    return static_cast<u32>(nw::snd::spy::internal::fnd::Time::Current().ToMilliSeconds()) - m_SpyFrameBase;
}

//----------------------------------------------------------
void
TimeModule::ResetSpyFrame()
{
    m_SpyFrameBase = static_cast<u32>(nw::snd::spy::internal::fnd::Time::Current().ToMilliSeconds());
}

//----------------------------------------------------------
void
TimeModule::PushCurrentTimeData()
{
    if(!IsInstalled())
    {
        return;
    }

    TimePacketData packetData;
    packetData.spyFrame = GetCurrentSpyFrame();
    packetData.appFrame = m_CurrentAppFrame;
    packetData.audioFrame =m_CurrentAudioFrame;

    if(GetController()->PushData(*this, &packetData, sizeof(TimePacketData)))
    {
#ifdef BUFFER_DEBUG_ENABLED
        NW_LOG(
            "[nw::snd::spy::SpyController] Pushed TimePacket : abs=%8d, app=%8d, audio=%8d.\n",
            packetData.spyFrame,
            packetData.appFrame,
            packetData.audioFrame);
#endif
    }
}

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
