﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../../precompiled.h"

#ifdef NW_SND_SPY_ENABLE

#include <nw/snd/spy/fnd/hio/sndspyfnd_HioInitializer.h>

#include <WinSock2.h>

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

//----------------------------------------------------------

u32 HioInitializer::m_Count = 0;

//----------------------------------------------------------
void
HioInitializer::Initialize()
{
    ++m_Count;

    if(m_Count > 1)
    {
        return;
    }

    WSADATA wsaData;
    WSAStartup(MAKEWORD(2,0), &wsaData);
}

//----------------------------------------------------------
void
HioInitializer::Finalize()
{
    if(m_Count == 0)
    {
        return;
    }

    --m_Count;

    if(m_Count == 0)
    {
        WSACleanup();
    }
}

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE
