﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/edit/sndedit_Types.h>
#include <nw/ut/ut_Inlines.h>
#include <nw/ut/ut_String.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//----------------------------------------------------------
void
Hash32::ToString(char* buffer, u32 length) const
{
    NW_ASSERT_NOT_NULL(buffer);
    NW_ASSERT(length >= Size * 4);

    ut::snprintf(
        buffer,
        length,
        length - 1,
        "%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x-%02x%02x%02x%02x",
        value[0], value[1], value[2], value[3],
        value[4], value[5], value[6], value[7],
        value[8], value[9], value[10], value[11],
        value[12], value[13], value[14], value[15],
        value[16], value[17], value[18], value[19],
        value[20], value[21], value[22], value[23],
        value[24], value[25], value[26], value[27],
        value[28], value[29], value[30], value[31]
    );
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw
