﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/basis/sndfnd_Memory.h>
#include <nw/snd/edit/hio/sndedit_HioStream.h>

#include <nw/math/math_Arithmetic.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

namespace nw {
namespace snd {
namespace edit {
namespace internal {


//----------------------------------------------------------
HioStream::HioStream()
{
    m_FrameCount = 0;
}

#if !defined(NW_SND_EDIT_USE_MCS)
//----------------------------------------------------------
void
HioStream::Initialize(void* workBuffer, u32 workBufferLength)
{
    m_Stream.Initialize(workBuffer, workBufferLength);
}

//----------------------------------------------------------
void
HioStream::Finalize()
{
    m_Stream.Finalize();
}
#endif

//----------------------------------------------------------
bool
HioStream::Open(ChannelType channel, void* buffer, u32 length)
{
    return m_Stream.Open(channel, buffer, length);
}

//----------------------------------------------------------
void
HioStream::Close()
{
    m_Stream.Close();
}

//----------------------------------------------------------
bool
HioStream::IsAvailable() const
{
#if defined(NW_SND_EDIT_USE_MCS)
    return m_Stream.IsAvailable();
#else
    return m_Stream.IsOpened();
#endif
}

//----------------------------------------------------------
u32
HioStream::GetReadableBytes()
{
    return m_Stream.GetReadableBytes();
}

//----------------------------------------------------------
s32
HioStream::Read(void* buffer, u32 length)
{
    return m_Stream.Read(buffer, length);
}

//----------------------------------------------------------
s32
HioStream::Skip(u32 length)
{
    return m_Stream.Skip(length);
}

//----------------------------------------------------------
s32
HioStream::Write(const void* buffer, u32 length)
{
    return m_Stream.Write(buffer, length);
}

//----------------------------------------------------------
bool
HioStream::Polling()
{
#if !defined(NW_SND_EDIT_USE_MCS)
    if (m_FrameCount >= 20)
    {
        m_FrameCount = 0;
        if (!m_Stream.Connect())
        {
            m_Stream.Disconnect();
            return false;
        }
    }
    ++m_FrameCount;

#endif
    return true;
}

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
