﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/ctrl/sndctrl_SoundObjectController.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/ut/ut_Inlines.h>

#if !defined(NW_RELEASE)
//#define NW_ENABLE_ERROR_DEBUG
#endif

namespace nw {
namespace snd {
namespace ctrl {

//----------------------------------------------------------
SoundObjectController::SoundObjectController() :
m_LastError(edit::SNDEDIT_RESULT_TRUE),
m_IsInitialized(false)
{
}

//----------------------------------------------------------
edit::Result
SoundObjectController::Initialize(SoundArchivePlayer* soundArchivePlayer)
{
    if(soundArchivePlayer == NULL)
    {
        NW_FATAL_ERROR("invalid arguments.\n");
        SetLastError(edit::SNDEDIT_RESULT_FAILED);
        return edit::Result(edit::SNDEDIT_RESULT_FAILED);
    }

    for(u32 index = 0; index < SOUND_CONTROLLER_COUNT; ++index)
    {
        edit::Result result = m_SoundController[index].Initialize(
            &m_SoundHandles[index],
            soundArchivePlayer);

        if(result.IsFailed())
        {
            Finalize();
            SetLastError(result);
            return result;
        }
    }

    m_IsInitialized = true;

    return edit::Result(edit::SNDEDIT_RESULT_TRUE);
}

//----------------------------------------------------------
void
SoundObjectController::Finalize()
{
    for(u32 index = 0; index < SOUND_CONTROLLER_COUNT; ++index)
    {
        m_SoundController[index].Finalize();
    }

    m_IsInitialized = false;
}

//----------------------------------------------------------
void
SoundObjectController::Update()
{
    NW_ASSERTMSG(IsInitialized(), "SoundObjectController is not initialized.\n");

    for(u32 index = 0; index < SOUND_CONTROLLER_COUNT; ++index)
    {
        m_SoundController[index].Update();
    }
}

//----------------------------------------------------------
void
SoundObjectController::SetLastError(edit::ResultType value)
{
    m_LastError = edit::Result(value);

#if defined(NW_ENABLE_ERROR_DEBUG)
    NW_LOG("[sndctrl] SoundObjectController::SetLastError '%s'.\n", edit::Result(value).ToString());
#endif
}

} // namespace nw::snd::ctrl
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
