﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_Config.h>
#include "nw/snd/ctrl/sndctrl_SequenceVariable.h"

#ifdef NW_SND_CONFIG_ENABLE_DEV

namespace nw        {
namespace snd       {
namespace ctrl      {
namespace internal  {

//----------------------------------------------------------
bool
SequenceVariableTraits::ValidateTrackNo(u32 nTrackNo)
{
    return ( SequenceVariableTraits::TrackCount > nTrackNo );
}

//----------------------------------------------------------
bool
SequenceVariableTraits::ValidateValue(s32 lValue)
{
    if( SequenceVariableTraits::InvalidValue == lValue ) return true;

    if( SequenceVariableTraits::MaxValue < lValue ) return false;
    if( SequenceVariableTraits::MinValue > lValue ) return false;

    return true;
}

//----------------------------------------------------------
SequenceVariable::SequenceVariable(void)
: m_lValue( SequenceVariableTraits::InvalidValue )
{
}

//----------------------------------------------------------
SequenceVariable::~SequenceVariable(void)
{
}

//----------------------------------------------------------
s32
SequenceVariable::GetValue()
{
    return m_lValue;
}

//----------------------------------------------------------
void
SequenceVariable::SetValue(s32 value)
{
    NW_ASSERT( SequenceVariableTraits::ValidateValue( value ) );

    m_lValue = value;
}

//----------------------------------------------------------
SequenceVariableContainer::SequenceVariableContainer()
: m_nType( SequenceVariableType_Global )
, m_nPreviewSoundIndex( 0 )
, m_nTrackNo( 0 )
{
}

//----------------------------------------------------------
bool
SequenceVariableContainer::Parse(const ToolSoundSequenceVariableContainer* pContainer)
{
    NW_ASSERT_NOT_NULL( pContainer );

    // コンテナの内容をパラメータに展開する
    m_nType               = static_cast<ToolSoundSequenceVariableType>((u32)pContainer->header.variableType);
    m_nPreviewSoundIndex  = pContainer->header.previewSoundIndex;
    m_nTrackNo            = pContainer->header.trackNo;

    for( s32 i = 0; i < SequenceVariableTraits::VariableCount; i++ ){
        m_variables[ i ].SetValue( pContainer->variables[ i ] );
    }

    return true;
}

//----------------------------------------------------------
void
SequenceVariableContainer::InvalidateAll()
{
    for( s32 i = 0; i < SequenceVariableTraits::VariableCount; i++ ){
        m_variables[ i ].SetValue( SequenceVariableTraits::InvalidValue );
    }
}

//----------------------------------------------------------
u32
SequenceVariableContainer::GetCount()
{
    return SequenceVariableTraits::VariableCount;
}

//----------------------------------------------------------
ToolSoundSequenceVariableType
SequenceVariableContainer::GetType()
{
    return m_nType;
}

//----------------------------------------------------------
u32
SequenceVariableContainer::GetPreviewPlayerIndex()
{
    return m_nPreviewSoundIndex;
}

//----------------------------------------------------------
u32
SequenceVariableContainer::GetTrackNo()
{
    return m_nTrackNo;
}

//----------------------------------------------------------
SequenceVariable
SequenceVariableContainer::operator [](s32 index)
{
    return m_variables[ index ];
}

} // namespace internal
} // namespace ctrl
} // namespace snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV
