﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_ThreadStack.h>
#include <nw/assert.h>

namespace nw {
namespace snd {
namespace internal {

void ThreadStack::Initialize( uptr ptr, size_t size )
{
    NW_ASSERT( !m_Addr );   // 再イニシャライズ禁止

    m_Addr = ptr;
    m_Size = size;
}

void ThreadStack::Finalize()
{
    m_Addr = 0;
    m_Size = 0;
}

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

