﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_StreamSoundPrefetchFile.h>
#include <nw/snd/snd_ElementType.h>

namespace nw {
namespace snd {
namespace internal {


//
// StreamSoundPrefetchFile::FileHeader
//
const StreamSoundFile::InfoBlock*
StreamSoundPrefetchFile::FileHeader::GetInfoBlock() const
{
    return reinterpret_cast<const StreamSoundFile::InfoBlock*>( GetBlock( ElementType_StreamSoundFile_InfoBlock ) );
}
const StreamSoundPrefetchFile::PrefetchDataBlock*
StreamSoundPrefetchFile::FileHeader::GetPrefetchDataBlock() const
{
    return reinterpret_cast<const PrefetchDataBlock*>( GetBlock( ElementType_StreamSoundFile_PrefetchDataBlock ) );
}
u32 StreamSoundPrefetchFile::FileHeader::GetPrefetchDataBlockSize() const
{
    return GetBlockSize( ElementType_StreamSoundFile_PrefetchDataBlock );
}

//
// StreamSoundPrefetchFile::PrefetchData
//
const StreamSoundPrefetchFile::PrefetchSample*
StreamSoundPrefetchFile::PrefetchData::GetPrefetchSample() const
{
    return reinterpret_cast<const PrefetchSample*>(
        ut::AddOffsetToPtr( this, toPrefetchSample.offset ) );
}

//
// StreamSoundPrefetchFile::PrefetchSample
//
const void*
StreamSoundPrefetchFile::PrefetchSample::GetSampleAddress() const
{
    return reinterpret_cast<const void*>( data );
}

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

