﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_SoundHandle.h>

namespace nw {
namespace snd {

/*---------------------------------------------------------------------------*
  Name:         DuplicateHandle

  Description:  変換コンストラクタ

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *---------------------------------------------------------------------------*/
void SoundHandle::detail_DuplicateHandle( SoundHandle* handle )
{
    DetachSound();

    if ( handle == NULL )
    {
        return;
    }

    // サウンドを取得
    if ( handle->IsAttachedSound() == false )
    {
        return;
    }

    internal::BasicSound* sound = handle->detail_GetAttachedSound();

    if ( sound != NULL )
    {
        // 一時ハンドルとしてAttachする
        detail_AttachSoundAsTempHandle( sound );
    }
}

/*---------------------------------------------------------------------------*
  Name:         detail_AttachSoundTemp

  Description:  ハンドルにサウンドを関連付ける

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *---------------------------------------------------------------------------*/
void SoundHandle::detail_AttachSoundAsTempHandle( internal::BasicSound* sound )
{
    NW_NULL_ASSERT( sound );

    m_pSound = sound;

    if ( m_pSound->IsAttachedTempGeneralHandle() )
    {
        m_pSound->DetachTempGeneralHandle();
    }
    m_pSound->m_pTempGeneralHandle = this;
}

/*---------------------------------------------------------------------------*
  Name:         detail_AttachSound

  Description:  ハンドルにサウンドを関連付ける

  Arguments:    sound - 関連付けるサウンド

  Returns:      None.
 *---------------------------------------------------------------------------*/
void SoundHandle::detail_AttachSound( internal::BasicSound* sound )
{
    NW_NULL_ASSERT( sound );

    m_pSound = sound;

    if ( m_pSound->IsAttachedGeneralHandle() )
    {
        m_pSound->DetachGeneralHandle();
    }
    m_pSound->m_pGeneralHandle = this;
}

/*---------------------------------------------------------------------------*
  Name:         DetachSound

  Description:  ハンドルに結びついているサウンドの関連を外す

  Arguments:    None.

  Returns:      None.
 *---------------------------------------------------------------------------*/
void SoundHandle::DetachSound()
{
    if ( IsAttachedSound() )
    {
        if ( m_pSound->m_pGeneralHandle == this )
        {
            m_pSound->m_pGeneralHandle = NULL;
        }
        if ( m_pSound->m_pTempGeneralHandle == this )
        {
            m_pSound->m_pTempGeneralHandle = NULL;
        }
    }
    if ( m_pSound != NULL )
    {
        m_pSound = NULL;
    }
}

} // namespace nw::snd
} // namespace nw

