﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_DisposeCallbackManager.h>
#include <nw/snd/snd_SoundThread.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

/* ========================================================================
        member function
   ======================================================================== */

/*---------------------------------------------------------------------------*
  Name:         GetInstance

  Description:  シングルトンのインスタンスを取得する

  Arguments:    なし

  Returns:      なし
 *---------------------------------------------------------------------------*/
DisposeCallbackManager& DisposeCallbackManager::GetInstance()
{
    static DisposeCallbackManager instance;
    return instance;
}

/*---------------------------------------------------------------------------*
  Name:         DisposeCallbackManager

  Description:  コンストラクタ

  Arguments:    なし

  Returns:      なし
 *---------------------------------------------------------------------------*/
DisposeCallbackManager::DisposeCallbackManager()
{
}

/*---------------------------------------------------------------------------*
  Name:         RegisterDisposeCallback

  Description:  無効化コールバックを登録する

  Arguments:    なし

  Returns:      なし
 *---------------------------------------------------------------------------*/
void DisposeCallbackManager::RegisterDisposeCallback( DisposeCallback* callback )
{
    m_CallbackList.PushBack( callback );

    // NN_LOG("regist %d %d\n",nn::os::Thread::GetCurrentId(),m_CallbackList.GetSize());
}

/*---------------------------------------------------------------------------*
  Name:         UnregisterDisposeCallback

  Description:  無効化コールバックの登録を解除する

  Arguments:    なし

  Returns:      なし
 *---------------------------------------------------------------------------*/
void DisposeCallbackManager::UnregisterDisposeCallback( DisposeCallback* callback )
{
    m_CallbackList.Erase( callback );

    // NN_LOG("unregist %d %d\n",nn::os::Thread::GetCurrentId(),m_CallbackList.GetSize());
}

/*---------------------------------------------------------------------------*
  Name:         GetCallbackCount

  Description:  登録されている無効化コールバック数を取得する

  Arguments:    なし

  Returns:      なし
 *---------------------------------------------------------------------------*/
unsigned long DisposeCallbackManager::GetCallbackCount() const
{
    return m_CallbackList.GetSize();
}

/*---------------------------------------------------------------------------*
  Name:         Dispose

  Description:  登録されたオブジェクトに対して無効化を行う

  Arguments:    なし

  Returns:      なし
 *---------------------------------------------------------------------------*/
void DisposeCallbackManager::Dispose( const void* mem, unsigned long size )
{
    const void* start = mem;
    const void* end = static_cast<const u8*>( mem ) + size;

    for ( CallbackList::Iterator itr = GetInstance().m_CallbackList.GetBeginIter();
          itr != GetInstance().m_CallbackList.GetEndIter();
        )
    {
        CallbackList::Iterator curItr = itr++;
        curItr->InvalidateData( start, end );
    }
}

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

