﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_DecodeAdpcm.h>

namespace nw {
namespace snd {
namespace internal {

namespace
{
}

void DecodeDspAdpcm(
        u32 playPosition,                   // adpcmData から数えたデコード開始位置
        nw::snd::AdpcmContext& context,     // デコード用 ADPCM コンテキスト
        const nw::snd::AdpcmParam& param,   // デコード用 ADPCM パラメータ
        const void* adpcmData,              // ADPCM エンコードデータ
        u32 decodeSamples,                  // デコードサンプル数
        s16* dest )                         // デコードデータ出力先
{
    u32 frame = playPosition / 14;
    u32 frameFrac = playPosition - frame * 14;
    const u8* frameBegin = reinterpret_cast<const u8*>(reinterpret_cast<u32>(adpcmData) + (frame*8));

    s32 pred  = static_cast<s32>(context.pred_scale >> 4);
    s32 scale = static_cast<s32>(context.pred_scale & 0xf);

    for( unsigned i=0; i<decodeSamples; i++ )
    {
        if ( frameFrac == 0 )
        {
            const u8 pred_scale = *frameBegin;
            context.pred_scale = pred_scale;
            pred = (pred_scale >> 4);
            scale = (pred_scale & 0xf);
        }

        u8 code = frameBegin[frameFrac/2+1];
        if ( frameFrac & 0x1 )
        {
            code &= 0xf;
        }
        else
        {
            code >>= 4;
        }

        s16 nibble = code;
        nibble <<= 12;
        nibble >>= 1;

        s16 a1   = static_cast<s16>(param.coef[pred][0]);
        s16 a2   = static_cast<s16>(param.coef[pred][1]);
        s16 gain = static_cast<s16>(1 << scale);

        s32 val = a1 * static_cast<s16>(context.yn1);
        val  += a2 * static_cast<s16>(context.yn2);
        val  += gain * nibble;
        val >>= 10;
        val  += 1;
        val >>= 1;

        if (val > 32767)
        {
            val = 32767;
        }
        else if (val < -32768)
        {
            val = -32768;
        }
        s16 smp = static_cast<s16>(val);

        context.yn2 = context.yn1;
        context.yn1 = smp;

        *dest = smp;
        ++dest;

        frameFrac++;
        if ( frameFrac == 14 )
        {
            frameFrac = 0;
            frameBegin += 8;
        }
    }
}


}}}
