﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/snd_ChannelManager.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

/* ========================================================================
        ChannelManager class
   ======================================================================== */

ChannelManager& ChannelManager::GetInstance()
{
    static ChannelManager instance;
    return instance;
}

ChannelManager::ChannelManager()
: m_IsInitialized( false ),
  m_ChannelCount( 0 )
{
}

size_t ChannelManager::GetRequiredMemSize( int channelCount )
{
    // return sizeof( Channel ) * ( channelCount + 1 );
    return sizeof( Channel ) * ( channelCount * 2 );
}

void ChannelManager::Initialize( void* mem, unsigned long memSize )
{
    if ( m_IsInitialized ) return;

    m_ChannelCount = m_Pool.Create( mem, memSize );

    m_IsInitialized = true;
}

void ChannelManager::Finalize()
{
    if ( !m_IsInitialized ) return;

    // リスト中の全ボイスを停止
    for ( ChannelList::Iterator itr = m_ChannelList.GetBeginIter();
          itr != m_ChannelList.GetEndIter();
        )
    {
        Channel* channel = &*itr;
        itr++;

        channel->Stop();
        channel->CallChannelCallback( Channel::CALLBACK_STATUS_CANCEL );
        Free(channel);
    }

    NW_ASSERT( m_ChannelList.IsEmpty() );

    m_Pool.Destroy();

    m_IsInitialized = false;
}

Channel* ChannelManager::Alloc()
{
    Channel* channel = m_Pool.Alloc();
    if ( channel == NULL ) return NULL;
    m_ChannelList.PushBack( channel );
    return channel;
}
void ChannelManager::Free( Channel* channel )
{
    m_ChannelList.Erase( channel );
    m_Pool.Free( channel );
}

void ChannelManager::UpdateAllChannel()
{
    for ( ChannelList::Iterator itr = m_ChannelList.GetBeginIter();
          itr != m_ChannelList.GetEndIter();
        )
    {
        Channel* channel = &*itr;
        itr++;

        channel->Update( true );
        if ( ! channel->IsActive() ) {
            channel->CallChannelCallback( Channel::CALLBACK_STATUS_STOPPED );
            Free(channel);
        }
    }
}

} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

