﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if !defined( NW_PLATFORM_CTR )
#include <nw/ut/ut_String.h>
#endif
#include <nw/ut/ut_Inlines.h>
#include <nw/snd/fnd/string/sndfnd_String.h>

#if defined( NW_PLATFORM_CTR )
#ifndef NW_ASSERT_NOT_NULL
#define NW_ASSERT_NOT_NULL NW_NULL_ASSERT
#endif
#endif

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//----------------------------------------------------------
void
String::Copy(char* dest, u32 destLength, const char* source, u32 sourceLength)
{
    NW_ASSERT_NOT_NULL(dest);
    NW_ASSERT_NOT_NULL(source);
    NW_ASSERTMSG(sourceLength <= destLength, "buffer over flow.\n");

    // コピーバッファ競合チェック
    NW_ASSERT(dest >= source || static_cast<u32>(ut::GetOffsetFromPtr(dest, source)) >= destLength);
    NW_ASSERT(dest <= source || static_cast<u32>(ut::GetOffsetFromPtr(source, dest)) >= sourceLength);

    u32 length = std::min(destLength, sourceLength);

    for(u32 sourceIndex = 0; sourceIndex < length; ++sourceIndex)
    {
        dest[sourceIndex] = source[sourceIndex];
    }
}

//----------------------------------------------------------
void
String::SafeCopy(char* dest, u32 destLength, const char* source, u32 sourceLength)
{
    Copy(dest, destLength, source, sourceLength);

    // 終端文字を付加する
    if(sourceLength > 0 && source[sourceLength - 1] != '\0')
    {
        NW_ASSERTMSG(destLength > sourceLength, "buffer over flow.\n");
        dest[sourceLength] = '\0';
    }
}

#if !defined( NW_PLATFORM_CTR )
//----------------------------------------------------------
s32
String::IndexOf(const char* source, char targetChar, u32 maxLength)
{
    const char* strPtr = ut::strnchr(source, maxLength, targetChar);

    return strPtr == NULL ? INDEX_NOT_FOUND : strPtr - source;
}

//----------------------------------------------------------
s32
String::LastIndexOf(const char* source, char targetChar, u32 maxLength)
{
    s32 index = 0;
    s32 lastIndex = INDEX_NOT_FOUND;
    const char* current = source;
    while (index != INDEX_NOT_FOUND)
    {
        const char* next = ut::strnchr(current, maxLength, targetChar);
        if (next != NULL)
        {
            index = next - source;
            lastIndex = index;
        }
        else
        {
            index = INDEX_NOT_FOUND;
        }

        ++next;
        current = next;
    }

    return lastIndex;
}
#endif

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
