﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/snd/fnd/basis/sndfnd_Time.h>

#include <nn/os/os_Tick.h>

namespace {
    s64 NanoSecondsToTicks(s64 value)
    {
        nn::TimeSpan timeSpan = nn::TimeSpan::FromNanoSeconds(value);
        nn::os::Tick tick(timeSpan);
        return tick.GetInt64Value();
    }

    s64 MicroSecondsToTicks(s64 value)
    {
        return NanoSecondsToTicks(value * 1000);
    }

    s64 MilliSecondsToTicks(s64 value)
    {
        return NanoSecondsToTicks(value * 1000 * 1000);
    }

    s64 TicksToNanoSeconds(s64 ticks)
    {
        nn::os::Tick tick(ticks);
        nn::TimeSpan timeSpan = tick.ToTimeSpan();
        return timeSpan.GetNanoSeconds();
    }

    s64 TicksToMicroSeconds(s64 ticks)
    {
        nn::os::Tick tick(ticks);
        nn::TimeSpan timeSpan = tick.ToTimeSpan();
        return timeSpan.GetMicroSeconds();
    }

    s64 TicksToMilliSeconds(s64 ticks)
    {
        nn::os::Tick tick(ticks);
        nn::TimeSpan timeSpan = tick.ToTimeSpan();
        return timeSpan.GetMilliSeconds();
    }
}

namespace nw {
namespace snd {
namespace internal {
namespace fnd {

//----------------------------------------------------------
TimeSpan
Time::Current()
{
    return TimeSpan(nn::os::GetSystemTick().GetInt64Value());
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromNanoSeconds(s64 value)
{

    return TimeSpan(NanoSecondsToTicks(value));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMicroSeconds(s64 value)
{
    return TimeSpan(MicroSecondsToTicks(value));
}

//----------------------------------------------------------
TimeSpan
TimeSpan::FromMilliSeconds(s64 value)
{
    return TimeSpan(MilliSecondsToTicks(value));
}

//----------------------------------------------------------
s64
TimeSpan::ToNanoSeconds() const
{
    return TicksToNanoSeconds(m_TickSpan);
}

//----------------------------------------------------------
s64
TimeSpan::ToMicroSeconds() const
{
    return TicksToMicroSeconds(m_TickSpan);
}

//----------------------------------------------------------
s64
TimeSpan::ToMilliSeconds() const
{
    return TicksToMilliSeconds(m_TickSpan);
}

} // namespace nw::snd::internal::fnd
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw
