# /*---------------------------------------------------------------------------*
#   Project:  NintendoWare
# 
#   Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.
# 
#   These coded instructions, statements, and computer programs contain proprietary
#   information of Nintendo and/or its licensed developers and are protected by
#   national and international copyright laws. They may not be disclosed to third
#   parties or copied or duplicated in any form, in whole or in part, without the
#   prior written consent of Nintendo.
# 
#   The content herein is highly confidential and should be handled accordingly.
#  *---------------------------------------------------------------------------*/

LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)
PROGRAMS_DIR      := $(LOCAL_PATH)/../../../../..
IRIS_DIR          := $(PROGRAMS_DIR)/Iris
LIBRARIES_DIR     := $(IRIS_DIR)/Sources/Libraries

LOCAL_MODULE    := nw_snd

# math
LOCAL_SRC_FILES := \
                   $(LIBRARIES_DIR)/Sys/math/math_Constant.cpp \
                   $(LIBRARIES_DIR)/Sys/math/math_Triangular.cpp

# ut/os, ut/res
LOCAL_SRC_FILES += \
				   $(LIBRARIES_DIR)/Sys/ut/os/ut_Event.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/os/ut_MessageQueue.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/os/ut_Mutex.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/os/ut_Print.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/os/ut_Thread.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/os/ut_Time.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/res/ut_ResDictionary.cpp

# ut
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/Sys/ut/ut_BinaryFileFormat.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_FileStream.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_FrameHeap.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_HeapBase.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_IoStream.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_LinkList.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_List.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_MemoryAllocator.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_SafeString.cpp \
                   $(LIBRARIES_DIR)/Sys/ut/ut_String.cpp

# winext / ai
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/WinExt/ai/ai.cpp \
                   $(LIBRARIES_DIR)/WinExt/ai/ai_dma.cpp \
                   $(LIBRARIES_DIR)/WinExt/ai/SoundEngineSLES.cpp

# winext / ax
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/WinExt/ax/AX2.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXAlloc.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXAux.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXCL.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXComp.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXFX.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXHelper.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXOut.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXProf.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXRenderCosts.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXSPB.cpp \
                   $(LIBRARIES_DIR)/WinExt/ax/AXVPB.cpp

# winext / axfx
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXChorusExp.cpp \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXDelayExp.cpp \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXHooks.cpp \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXLfoTable.cpp \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXReverbHiExp.cpp \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXReverbStdExp.cpp \
                   $(LIBRARIES_DIR)/WinExt/axfx/AXFXSrcCoef.cpp

# winext / mem
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_allocator.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_arena.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_defaultHeap.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_expHeap.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_frameHeap.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_heapCommon.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_list.cpp \
                   $(LIBRARIES_DIR)/WinExt/mem/mem_unitHeap.cpp

# winext / os
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/WinExt/os/OSCore.cpp \
                   $(LIBRARIES_DIR)/WinExt/os/OSError.cpp \
                   $(LIBRARIES_DIR)/WinExt/os/OSInterrupt.cpp \
                   $(LIBRARIES_DIR)/WinExt/os/OSMutex.cpp \
                   $(LIBRARIES_DIR)/WinExt/os/OSTime.cpp

# snd
LOCAL_SRC_FILES += \
                   $(LIBRARIES_DIR)/Snd/snd/snd_AllImpl.cpp \
                   $(LIBRARIES_DIR)/Snd/snd/snd_AllImpl_actor.cpp \
                   $(LIBRARIES_DIR)/Snd/snd/snd_AllImpl_fnd.cpp \
                   $(LIBRARIES_DIR)/Snd/snd/snd_AllImpl_fx.cpp \
                   $(LIBRARIES_DIR)/Snd/snd/snd_AllImpl_sound.cpp


CAFE_INCLUDES    := $(IRIS_DIR)/Include/winext

LOCAL_C_INCLUDES := \
					$(IRIS_DIR)/Include  \
					$(CAFE_INCLUDES)

LOCAL_CFLAGS    := -DDISABLE_IMPORTGL

CFLAGS_OPTIM    := -funswitch-loops           \
				   -fomit-frame-pointer       \
				   -fno-strict-aliasing       \
				   -funwind-tables            \
				   -fno-short-enums

ifeq ($(NW_BUILD), Debug)
LOCAL_CFLAGS    += -DNW_DEBUG
else
ifeq ($(NW_BUILD), Release)
LOCAL_CFLAGS    += -DNW_RELEASE $(CFLAGS_OPTIM)
else # Develop
LOCAL_CFLAGS    += -DNW_DEVELOP $(CFLAGS_OPTIM)
endif
endif

# LOCAL_CFLAGS    += -DHAVE_NEON=1           
# LOCAL_ARM_NEON  := true

LOCAL_CPPFLAGS  := -std=c++11                 \
                   -fdelayed-template-parsing \
                   -Wno-non-pod-varargs       \
                   -Wno-c++11-narrowing

include $(BUILD_STATIC_LIBRARY)
