﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/vwrlyt/cafe/vwrlyt_FindableArcResourceAccessorCafe.h>
#include <nw/lyt/lyt_Resources.h>
#include <nw/ut.h>

#if defined(NW_VWRLYT_ENABLE)

namespace nw
{
namespace vwrlyt
{

bool FindableArcResourceAccessor::Attach(void* archiveStart, const char* resourceRootDirectory)
{
    if (lyt::ArcResourceAccessor::Attach(archiveStart, resourceRootDirectory))
    {
        m_FindArcHandle.PrepareArchive(archiveStart);
        return true;
    }
    else
    {
        return false;
    }
}

const char* FindableArcResourceAccessor::FindFile(lyt::ResType resType, const char* pPrevFileName)
{
    ut::FixedSafeString<cFileNameMax> tempBuf;
    if (pPrevFileName)
    {
        tempBuf.copy("/");
        tempBuf.append(pPrevFileName);
    }

    char resTypeStr[6];
    resTypeStr[0] = u8(resType >> 24);
    resTypeStr[1] = u8(resType >> 16);
    resTypeStr[2] = u8(resType >>  8);
    resTypeStr[3] = u8(resType >>  0);
    resTypeStr[4] = '/';
    resTypeStr[5] = 0;

    u32 dir = 0;
    lyt::ArcEntry dirEntry;

    while (m_FindArcHandle.ReadEntry(&dir, &dirEntry, 1))
    {
        if (pPrevFileName)
        {
            const char* substr = std::strstr(dirEntry.name, tempBuf.c_str());
            if (substr)
            {
                pPrevFileName = NULL;
            }
        }
        else
        {
            const char* substr = std::strstr(dirEntry.name, resTypeStr);
            if (substr)
            {
                // 指定されたresTypeのファイルが見つかった
                m_FileNameBuffer.copy(substr + 5);
                return m_FileNameBuffer.c_str();
            }
        }
    }

    return NULL;
}

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
