﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_ProfileHelper.h>

#include <nw/lyt/lyt_Layout.h>
#include <nw/lyt/lyt_Picture.h>
#include <nw/lyt/lyt_Window.h>
#include <nw/lyt/lyt_TextBox.h>
#include <nw/lyt/lyt_Bounding.h>
#include <nw/lyt/lyt_Parts.h>
#include <nw/ut/ut_Memory.h>

namespace nw
{
namespace lyt
{

//----------------------------------------
int
ProfileHelper::GetQuantityOfGroup(const Layout& layout)
{
    return layout.GetGroupContainer()->GetGroupList().size();
}

//----------------------------------------
int
ProfileHelper::GetQuantityOfAllPane(const nw::lyt::Pane* pane)
{
    if (pane == NULL) { return 0; }

    int quantity = 1;

    const nw::lyt::PaneList& children = pane->GetChildList();
    for (nw::lyt::PaneList::const_iterator child = children.begin();
        child != children.end(); ++child)
    {
        quantity += GetQuantityOfAllPane(&(*child));
    }
    return quantity;
}

//----------------------------------------
int
ProfileHelper::GetQuantityOf(nw::lyt::PaneType paneType, const nw::lyt::Pane* pane)
{
    if (pane == NULL) { return 0; }

    int quantity;
    switch (paneType)
    {
    case nw::lyt::PANETYPE_NULL:
        quantity = (nw::ut::IsTypeOf<nw::lyt::Pane>(pane)) ? 1 : 0;
        break;
    case nw::lyt::PANETYPE_PICTURE:
        quantity = (nw::ut::IsTypeOf<nw::lyt::Picture>(pane)) ? 1 : 0;
        break;
    case nw::lyt::PANETYPE_WINDOW:
        quantity = (nw::ut::IsTypeOf<nw::lyt::Window>(pane)) ? 1 : 0;
        break;
    case nw::lyt::PANETYPE_TEXTBOX:
        quantity = (nw::ut::IsTypeOf<nw::lyt::TextBox>(pane)) ? 1 : 0;
        break;
    case nw::lyt::PANETYPE_BOUNDING:
        quantity = (nw::ut::IsTypeOf<nw::lyt::Bounding>(pane)) ? 1 : 0;
        break;
    case nw::lyt::PANETYPE_PARTS:
        quantity = (nw::ut::IsTypeOf<nw::lyt::Parts>(pane)) ? 1 : 0;
        break;
    default:
        quantity = 0;
        break;
    }

    const nw::lyt::PaneList& children = pane->GetChildList();
    for (nw::lyt::PaneList::const_iterator child = children.begin();
        child != children.end(); ++child)
    {
        quantity += GetQuantityOf(paneType, &(*child));
    }

    return quantity;
}

} // namespace lyt
} // namespace nw

