﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nw/lyt/lyt_Layout.h>
#include <nw/lyt/lyt_ControlCreator.h>
#include <nw/ctrl/ctrl_TouchDragButton.h>

namespace nw
{
namespace ctrl
{

TouchDragButton::TouchDragButton()
 : DragButton()
{
    // ドラッグの設定
    SetDragMode(DRAG_MODE_ON_HIT);
    // offとdownは受け付けない
    SetAcceptAction(ACTION_OFF, false);
    SetAcceptAction(ACTION_DOWN, false);
}

void TouchDragButton::Build(const lyt::ControlSrc& controlSrc, lyt::Layout* layout)
{
    // Touchアニメの取得(実際にはDownに格納)
    m_DownAnimator = layout->CreateGroupAnimatorAuto(controlSrc.FindFunctionalAnimName("Touch"), true);
    NW_ASSERTMSG(m_DownAnimator, "cannot create TouchAnimator[%s] for Layout[%s]", controlSrc.FindFunctionalAnimName("Touch"), layout->GetName());
    m_DownAnimator->StopAtMin();
    // Releaseアニメの取得(実際にはCancelに格納)
    m_CancelAnimator = layout->CreateGroupAnimatorAuto(controlSrc.FindFunctionalAnimName("Release"), false);
    NW_ASSERTMSG(m_CancelAnimator, "cannot create CancelAnimator[%s] for Layout[%s]", controlSrc.FindFunctionalAnimName("Release"), layout->GetName());
    // Disableアニメがあれば作成
    {
        const char* anim_name = controlSrc.FindFunctionalAnimName("Disable");
        if (anim_name && anim_name[0]) {
            m_DisableAnimator = layout->CreateGroupAnimatorAuto(anim_name, true);
        }
    }
    // 当たりのペイン
    m_HitPane = layout->GetRootPane()->FindPaneByName(controlSrc.FindFunctionalPaneName("Hit"));
    NW_ASSERTMSG(m_HitPane, "cannot get HitPane[%s] for Layout[%s]", controlSrc.FindFunctionalPaneName("Hit"), layout->GetName());

    // ボタンの名前は、レイアウトが部品であれば部品ペイン名（ルートペインとなっている）、
    // 部品でなければレイアウト名とする
    if (layout->IsPartsLayout()) {
        m_Name = layout->GetRootPane()->GetName();
    } else {
        m_Name = layout->GetName();
    }

    mRootPane = layout->GetRootPane();
}

bool TouchDragButton::ProcessOn()
{
    switch (m_State) {
    case STATE_OFF_IDLE:
        ChangeState(STATE_DOWN);
        StartDown();
        return true;
    case STATE_ON:
        return true;
    case STATE_OFF:
        return true;
    case STATE_ON_IDLE:
        return true;
    case STATE_DOWN:
        return true;
    case STATE_DOWN_IDLE:
        return true;
    case STATE_CANCEL:
        // Releaseアニメ中にタッチされた場合は
        // キューに入れて待つ
        return false;
    };

    return true;
}

bool TouchDragButton::ProcessCancel()
{
    switch (m_State) {
    case STATE_OFF_IDLE:
        return true;
    case STATE_ON:
        return true;
    case STATE_OFF:
        return true;
    case STATE_ON_IDLE:
        return true;
    case STATE_DOWN:
        // Touchアニメ中に離した場合は
        // キューに入れて待つ
        return false;
    case STATE_DOWN_IDLE:
        ChangeState(STATE_CANCEL);
        StartCancel();
        return true;
    case STATE_CANCEL:
        return true;
    };

    return true;
}

void TouchDragButton::FinishCancel()
{
    // ReleaseアニメのあとはOFF_IDLEに戻る
    ChangeState(STATE_OFF_IDLE);
}

} // namespace nw::ctrl
} // namespace nw
