﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VWRLYT_HIO_LISTENER_CAFE_H_
#define NW_VWRLYT_HIO_LISTENER_CAFE_H_

#include <nw/vwrlyt/vwrlyt_Config.h>
#if defined(NW_VWRLYT_ENABLE)

#include <nw/types.h>
#include <cafe/hio.h>

namespace nw
{
namespace vwrlyt
{

class HIOListener
{
public:
    enum
    {
        cMessageBufSize = 512
    };

    HIOListener();

    virtual ~HIOListener();

    void StartListen();

    const char* GetMessage();

    void ClearMessage();

    void EndListen();

protected:
    bool m_IsListening;
    bool m_HasMessage;
    char m_MessageBuffer[cMessageBufSize];
    HIOHandle m_Handle;

    static void ReadCallback(HIOStatus status, void* context);
    static void ConnectCallback(HIOStatus status, void* context);

};

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
#endif
