﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_VWRLYT_FINDABLE_ARC_RESOURCE_ACCESSOR_CAFE_H_
#define NW_VWRLYT_FINDABLE_ARC_RESOURCE_ACCESSOR_CAFE_H_

#include <nw/vwrlyt/vwrlyt_Config.h>
#if defined(NW_VWRLYT_ENABLE)

#include <nw/lyt/lyt_ArcResourceAccessor.h>
#include <nw/ut/ut_SafeString.h>

namespace nw
{
namespace vwrlyt
{

class FindableArcResourceAccessor : public lyt::ArcResourceAccessor
{
public:
    FindableArcResourceAccessor() : lyt::ArcResourceAccessor() {}

    bool Attach(void* archiveStart, const char* resourceRootDirectory);

    // 指定したリソースタイプのファイル名を得る。
    // DirResourceAccessorのインターフェースと合わせるため、現状クラス内のバッファのアドレスを
    // 返しています。このメソッドから返された領域は、次のFindFileの呼び出し時に破壊されます。
    virtual const char* FindFile(lyt::ResType resType, const char* pPrevFileName);

protected:
    enum
    {
            cFileNameMax = 128
    };

    ut::FixedSafeString<cFileNameMax> m_FileNameBuffer;
    lyt::ArchiveHandle m_FindArcHandle;

};

} // namespace vwrlyt
} // namespace nw

#endif // NW_VWRLYT_ENABLE
#endif
