﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SNDUTIL_FILEREADER_H_
#define NW_SNDUTIL_FILEREADER_H_

#include <nw/config.h>

#if defined(NW_PLATFORM_CAFE)
    #include <cafe/fs.h>
#elif defined(NW_USE_NINTENDO_SDK)
    #include <nn/fs.h>
#elif defined(NW_PLATFORM_WIN32)
    #include <Windows.h>
#endif

namespace nw {
namespace snd {
namespace util {

//! @brief  ファイルシステム上のファイルを読み込むことのできる簡単なクラスです。
//!
//!         Cafe 版では、内部で FSClient および FSCmdBlock をひとつずつ保持します。
class FileReader
{
public:
    enum Origin
    {
        ORIGIN_BEGIN,
        ORIGIN_CURRENT,
        ORIGIN_END
    };

    enum Result
    {
        RESULT_SUCCESS,
        RESULT_NOT_INITIALIZED,
        RESULT_NOT_OPEN,
        RESULT_INVALID_ARGUMENT,
        RESULT_FAILED_OPEN_FILE,
        RESULT_FAILED_GET_FILESIZE,
        RESULT_FAILED_READ_FILE,
        RESULT_FAILED_SEEK_FILE
    };

    FileReader();
    virtual ~FileReader();

#if defined(NW_PLATFORM_CAFE)
    Result Initialize(FSClient* client);
#elif defined(NW_USE_NINTENDO_SDK)
    Result Initialize();
#elif defined(NW_PLATFORM_WIN32)
    Result Initialize();
#endif
    Result Finalize();

    Result Open(const char* path);
    Result Close();
    bool IsOpen() const { return m_IsOpen; }

    Result Read(void* buf, u32 length, s32* readSize);
    Result Seek(s32 offset, Origin origin = ORIGIN_BEGIN);
    u32 GetSize() const { return m_FileSize; }
    u32 Tell() const { return m_FilePosition; }

private:
    u32 m_FilePosition;
    u32 m_FileSize;
    bool m_IsInitialized;
    bool m_IsOpen;
    u8 padding[2];

#if defined(NW_PLATFORM_CAFE)
    FSClient* m_pFsClient;
    FSCmdBlock m_FsCmdBlock;
    FSFileHandle m_FsFileHandle;
    FSStat m_FsStat;
#elif defined(NW_USE_NINTENDO_SDK)
    nn::fs::FileHandle m_FileHandle;
#elif defined(NW_PLATFORM_WIN32)
    void* m_pFileHandle;
#endif
};

} // namespace nw::snd::util
} // namespace nw::snd
} // namespace nw


#endif /* NW_SNDUTIL_FILEREADER_H_ */

