﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_DATA_ID_H_
#define NW_SND_SPY_DATA_ID_H_

#include <nw/snd/spy/sndspy_Config.h>
#ifdef NW_SND_SPY_ENABLE

namespace nw {
namespace snd {
namespace spy {

//----------------------------------------------------------
//! @briefprivate
//!
//! @brief Spy データの識別子です。
enum SpyDataID
{
    DATA_ID_INVALID = 0, //!< 無効値
    DATA_ID_MIN = 1, //!< SpyDataID の最小値
    DATA_ID_MAX = 1024 //!< SpyDataID の最大値（SelectDataIDパケットのサイズによる制限）
};

} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_ENABLE

#endif // NW_SND_SPY_DATA_ID_H_
