﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_SPY_FND_CRITICAL_SECTION_H_
#define NW_SND_SPY_FND_CRITICAL_SECTION_H_

#if defined(NW_PLATFORM_CAFE)
#include <cafe/os/OSMutex.h>
#endif

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

class CriticalSection
{
private:
#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    static const u32 CRITICAL_SECTION_SIZE = 24;
#endif

private:
    NW_DISALLOW_COPY_AND_ASSIGN(CriticalSection);

public:
    CriticalSection();
    ~CriticalSection();

public:
    void Enter();
    bool TryEnter();
    void Leave();

private:
    void Initialize();
    void Finalize();

private:
    bool m_IsInitialized;
    u8   m_Padding[3];

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    u32  m_CriticalSection[CRITICAL_SECTION_SIZE / sizeof(u32)];
#elif defined(NW_PLATFORM_CAFE)
    OSMutex m_Mutex;
#endif
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CAFE)
#include <nw/snd/spy/fnd/os/Cafe/sndspyfnd_CriticalSectionImplCafe.h>
#endif

namespace nw {
namespace snd {
namespace spy {
namespace internal {
namespace fnd {

class ScopedCriticalSection
{
private:
    NW_DISALLOW_COPY_AND_ASSIGN(ScopedCriticalSection);

public:
    explicit ScopedCriticalSection(CriticalSection& lock) : m_Lock(lock)
    {
        m_Lock.Enter();
    }

    ~ScopedCriticalSection()
    {
        m_Lock.Leave();
    }

private:
    CriticalSection& m_Lock;
};

} // namespace nw::snd::spy::internal::fnd
} // namespace nw::snd::spy::internal
} // namespace nw::snd::spy
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_SPY_FND_CRITICAL_SECTION_H_
