﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_STREAM_TRACK_H_
#define NW_SND_STREAM_TRACK_H_

#include <nw/snd/snd_StreamSoundFileReader.h>
#include <nw/snd/snd_MultiVoice.h>

namespace nw {
namespace snd {
namespace internal {
namespace driver {

struct StreamChannel
{
    // 関数
    void AppendWaveBuffer( WaveBuffer* pBuffer, bool lastFlag );

    // データ
    void*             m_pBufferAddress;   // ストリームデータバッファ
    MultiVoice*       m_pVoice;
    WaveBuffer        m_WaveBuffer[STRM_DATA_LOAD_TASK_MAX];
    AdpcmContext      m_AdpcmContext[STRM_DATA_LOAD_TASK_MAX];
};


struct StreamTrack
{
public:
    bool m_ActiveFlag;
    StreamChannel* m_pChannels[WAVE_CHANNEL_MAX];

    // データ
    u8 channelCount;
    u8 volume;
    u8 pan;
    u8 span;
    u8 mainSend;
    u8 fxSend[AUX_BUS_NUM];
    u8 lpfFreq;
    s8 biquadType;
    u8 biquadValue;
    u8 flags; // StreamSoundFile::SurroundMode が入る

    f32 m_Volume;
    s32 m_OutputLine;

    OutputParam m_TvParam;
    OutputParam m_DrcParam[DRC_OUT_COUNT];
};



} // namespace nw::snd::internal::driver
} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_STREAM_TRACK_H_ */

