﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FINAL_MIX_CALLBACK_H_
#define NW_SND_FINAL_MIX_CALLBACK_H_

#include <nw/snd/snd_Global.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @briefprivate
//! @brief  Cafe SDKのAXUserFinalMixCallbackを複数扱うためのインターフェイスです。
//!
//!         再生しているサウンドの波形情報を取得したい場合、このクラスを派生して@ref OnFinalMix に
//!         必要な処理を記述し、派生したクラスをサウンドライブラリ内部で管理しているリストに登録します。
//!
//!         @ref SoundSystem::AppendFinalMixCallback や @ref SoundSystem::PrependFinalMixCallback
//!         でサウンドライブラリ内部で管理しているリストにFinalMixCallbackを登録することができ、
//!         追加されたFinalMixCallbackはAXUserFinalMixCallbackが実行されるときに、リストの先頭から順に呼び出されます。
//!
//!         FinalMixCallbackで得られる波形情報は加工することができるため、リストに登録する順番によって、
//!         出力が変わる可能性がある点に注意してください。
//!
//!         FinalMixCallbackで加工した波形がどのタイミングで処理されているかについては、
//!         Cafe SDKのAXレンダリングモデルについてのドキュメント
//!         $CAFE_ROOT/system/docs/man/en_us/sound/overview/rendering.html\#mixing
//!         を参照してください。
//!
//! @see SoundSystem::AppendFinalMixCallback
//! @see SoundSystem::PrependFinalMixCallback
//! @see SoundSystem::EraseFinalMixCallback
//!
//! @date 2013/10/02 初版
//---------------------------------------------------------------------------
class FinalMixCallback
{
public:
    ut::LinkListNode m_Link;    //!< @briefprivate

    //---------------------------------------------------------------------------
    //! @brief  デストラクタです。
    //!
    //! @date 2013/10/02 初版
    //---------------------------------------------------------------------------
    virtual ~FinalMixCallback(){}

    //---------------------------------------------------------------------------
    //! @brief  出力波形が更新される度に行う処理を記述します。
    //!
    //! @param device どのデバイスの波形情報であるのかを示すパラメータです。
    //! @param data 波形情報を格納した構造体です。
    //!
    //! @see FinalMixData 構造体
    //!
    //! @date 2013/10/02 初版
    //---------------------------------------------------------------------------
    virtual void OnFinalMix(OutputDevice device, const FinalMixData* data) = 0;
};

/* ========================================================================
        非公開
   ======================================================================== */

namespace internal {

class ReadOnlyFinalMixCallback
{
public:
    ut::LinkListNode m_Link;

    virtual ~ReadOnlyFinalMixCallback(){}
    virtual void OnFinalMix(OutputDevice device, const FinalMixData* data){ (void)device; (void)data; }
};

} // namespace nw::snd::internal

} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_FINAL_MIX_CALLBACK_H_ */

