﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_BINARY_FILE_FORMAT_H_
#define NW_SND_BINARY_FILE_FORMAT_H_

#include <nw/snd/snd_Global.h>
#include <nw/snd/snd_Util.h>

namespace nw {
namespace snd {
namespace internal {

struct BinaryFileHeader
{
    s32 signature;            // ファイルシグネチャ   : 4 Byte
    u16 byteOrder;            // バイトオーダーマーク : 2 Byte
    u16 headerSize;           // ヘッダサイズ         : 2 Byte
    u32 version;              // ファイルバージョン   : 4 Byte
    u32 fileSize;             // ファイルサイズ       : 4 Byte
    u16 dataBlocks;           // ブロック数           : 2 Byte
    u16 reserved;             // 予約                 : 2 Byte
};

struct BinaryBlockHeader
{
    s32 kind;                 // ブロック種別名
    u32 size;                 // ブロック全体サイズ
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw

#endif /* NW_SND_BINARY_FILE_FORMAT_H_ */
