﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_ANIM_SOUND_FILE_READER_H_
#define NW_SND_ANIM_SOUND_FILE_READER_H_

#include <nw/snd/snd_AnimSoundFile.h>

namespace nw {
namespace snd {
namespace internal {

class AnimSoundFileReader
{
public:
    AnimSoundFileReader();
    bool Initialize( const void* bfasdFile );
    void Finalize();
    bool IsAvailable() const { return m_pAnimEventTable != NULL; }

    u32 GetFrameSize() const
    {
        if ( IsAvailable() )
        {
            return m_FrameSize;
        }
        return 0;
    }

    u32 GetEventCount() const
    {
        if ( IsAvailable() )
        {
            return m_pAnimEventTable->count;
        }
        return 0;
    }

    const AnimSoundFile::AnimEvent* GetAnimEvent( u32 eventIndex ) const
    {
        if ( IsAvailable() )
        {
            if ( eventIndex >= m_pAnimEventTable->count )
            {
                return NULL;
            }
            return &m_pAnimEventTable->item[eventIndex];
        }
        return NULL;
    }

    void Dump();

private:
    const AnimSoundFile::AnimEventTable* m_pAnimEventTable;
    u32 m_FrameSize;
};

} // namespace nw::snd::internal
} // namespace nw::snd
} // namespace nw


#endif /* NW_SND_ANIM_SOUND_FILE_READER_H_ */

