﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_FND_CONFIG_H_
#define NW_SND_FND_CONFIG_H_

//---------------------------------------------------------------------------
//! @briefprivate
//!
//! @namespace nw::snd::fnd
//!
//! @brief     サウンドランタイム用の基本クラスライブラリです。
//---------------------------------------------------------------------------

#include <nw/config.h>
#include <nw/types.h>

#include <nw/snd/fnd/basis/sndfnd_Target.h>
#include <nw/snd/fnd/basis/sndfnd_Platform.h>

#if defined( NW_PLATFORM_CTR )
#ifndef NW_ASSERT_NOT_NULL
#define NW_ASSERT_NOT_NULL NW_NULL_ASSERT
#endif

//--------------------------------------------------------------------------------
//  Index Bounds error
//

#ifndef NW_ASSERT_INDEX_BOUNDS
#define NW_ASSERT_INDEX_BOUNDS(index, size)                                            \
    NW_ASSERTMSG(static_cast<uint>(index) < static_cast<uint>(size),                   \
    "NW: " #index " is out of bounds. (%d)\n"                                          \
    "0 <= " #index " < %d is not satisfied.\n",                                        \
    static_cast<int>(index), static_cast<int>(size))
#endif
#endif

#endif // NW_SND_FND_CONFIG_H_
