﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_UPDATE_CACHES_HELPER_H_
#define NW_SND_EDIT_UPDATE_CACHES_HELPER_H_

#include <nw/snd/snd_Config.h>

#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/ut/ut_Preprocessor.h>
#include <nw/snd/fnd/os/sndfnd_Thread.h>
#include <nw/snd/edit/sndedit_Result.h>
#include <nw/snd/edit/sndedit_SoundArchiveEditor.h>

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_suppress 1301 // padding inserted in struct.
#pragma diag_suppress 2530 // padding added to end of struct.
#endif
#endif

namespace nw {
namespace snd {
namespace edit {

//---------------------------------------------------------------------------
//! @brief  【β版】キャッシュ更新を別スレッドで実行するためのヘルパークラスです。
//!
//!         このクラスを利用すると、SoundArchiveEditor のキャッシュ更新を
//!         簡単に別スレッドで処理させることができます。
//---------------------------------------------------------------------------
class UpdateCachesHelper
{
    NW_DISALLOW_COPY_AND_ASSIGN(UpdateCachesHelper);

public: // 定数の定義
    static const u32 DEFAULT_THREAD_STACK_SIZE = 16 * 1024; //!< スレッドスタックサイズのデフォルト値です。

public: // 型の定義
    //! @brief  スレッドのアフィニティマスクです。
    enum AFFINITY_MASK
    {
        CORE_DEFAULT = snd::internal::fnd::Thread::CORE_DEFAULT,   //!< コア指定を行いません。

        CORE_0  = snd::internal::fnd::Thread::CORE_0,              //!< コア0 を使用します。
        CORE_1  = snd::internal::fnd::Thread::CORE_1,              //!< コア1 を使用します。
        CORE_2  = snd::internal::fnd::Thread::CORE_2               //!< コア2 を使用します。
    };

public: // コンストラクタ
    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //---------------------------------------------------------------------------
    UpdateCachesHelper();

public: // メソッド
    //---------------------------------------------------------------------------
    //! @brief      ワーカースレッドを新規作成し、キャッシュ更新を開始します。
    //!
    //! @param[in]  soundArchiveEditor  更新対象の SoundArchiveEditor を指定します。
    //! @param[in]  threadStack         スレッドのスタックを指定します。
    //! @param[in]  threadStackSize     スレッドのスタックサイズを指定します。
    //! @param[in]  affinityMask        スレッドのアフィニティマスクを指定します。
    //! @param[in]  priority            スレッドのプライオリティを指定します。
    //!
    //! @return     処理結果を返します。
    //!
    //! @see        SoundArchiveEditor
    //! @see        Finalize()
    //! @see        IsInitialized()
    //! @see        DEFAULT_THREAD_STACK_SIZE
    //---------------------------------------------------------------------------
    Result Start(
        SoundArchiveEditor* soundArchiveEditor,
        void* threadStack,
        u32 threadStackSize,
        AFFINITY_MASK affinityMask = CORE_DEFAULT,
        u32 priority = snd::internal::fnd::Thread::DEFAULT_THREAD_PRIORITY);

    //---------------------------------------------------------------------------
    //! @brief  ワーカースレッドを停止し、キャッシュ更新も停止します。
    //---------------------------------------------------------------------------
    void Stop();

private: // メソッド
    u32 ThreadMain(void* parameter);

private: // メンバ変数
    SoundArchiveEditor* m_SoundArchiveEditor;
    Canceller           m_UpdateCachesCanceller;

    snd::internal::fnd::Thread m_Thread;
    bool                       m_IsExitThread;

    snd::internal::fnd::Thread::HandlerDelegate<UpdateCachesHelper> m_ThreadMainDelegate;
};

} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_default 1301 // padding inserted in struct.
#pragma diag_default 2530 // padding added to end of struct.
#endif
#endif

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_UPDATE_CACHES_HELPER_H_
