﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_QUERY_ITEMS_PACKET_H_
#define NW_SND_EDIT_QUERY_ITEMS_PACKET_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/snd/edit/hio/sndedit_HioProtocol.h>
#include <nw/snd/edit/res/sndedit_ResTypes.h>

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_suppress 1301 // padding inserted in struct.
#pragma diag_suppress 2530 // padding added to end of struct.
#endif
#endif

namespace nw {
namespace snd {
namespace edit {
namespace internal {

//---------------------------------------------------------------------------
//! @brief  アイテム一覧を問い合わせるパケットです。
//---------------------------------------------------------------------------
class QueryItemsPacket : public HioPacket
{
public:
    class Body : public HioPacketBody
    {
    };

public:
    QueryItemsPacket() : HioPacket(HIO_MESSAGE_QUERY_ITEMS, 0)
    {
    }

public:
    static u32 GetRequiredSize()
    {
        return sizeof(QueryItemsPacket);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

//---------------------------------------------------------------------------
//! @brief  QueryItemsPacket の返信パケットです。
//---------------------------------------------------------------------------
class QueryItemsReplyPacket : public HioPacket
{
private:
    // HACK : ResOffsetTable のアイテム数は、とりあえず最大256個とします。
    static const u32 MAX_ITEM_COUNT = 256;

public:
    enum ActionType
    {
        ACTION_NONE = 0,
        ACTION_UPDATE_ITEM = 1,
        ACTION_REMOVE_ITEM = 2
    };

    //! @brief  アイテム情報を格納します。
    struct ItemInfo
    {
        snd::internal::fnd::BinU32 action;
        ResName                    name;

        static u32 GetRequiredSize(u32 maxItemName)
        {
            return ut::RoundUp(
                sizeof(snd::internal::fnd::BinU32) + ResName::GetRequiredSize(maxItemName),
                snd::internal::fnd::MemoryTraits::DEFAULT_ALIGNMENT
                );
        }
    };

    struct Body : public HioPacketBody
    {
        Body() : actionForAllItems(ACTION_NONE) { }

        snd::internal::fnd::BinU32 actionForAllItems;
        ResOffsetTable<ItemInfo>   items;
    };

public:
    QueryItemsReplyPacket() : HioPacket(HIO_MESSAGE_QUERY_ITEM_INFO_REPLY, sizeof(Body))
    {
    }

public:
    static u32 GetRequiredSize(u32 maxItemName)
    {
        // ItemInfo は逐次読み込みするので、１つ分のメモリ領域で計算します。
        return ut::RoundUp(
            sizeof(QueryItemsReplyPacket) +
            sizeof(Offset) * MAX_ITEM_COUNT +
            ItemInfo::GetRequiredSize(maxItemName),
            snd::internal::fnd::MemoryTraits::DEFAULT_ALIGNMENT);
    }

    Body&       GetBody() { return m_Body; }
    const Body& GetBody() const { return m_Body; }

private:
    Body m_Body;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_default 1301 // padding inserted in struct.
#pragma diag_default 2530 // padding added to end of struct.
#endif
#endif

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_QUERY_ITEMS_PACKET_H_
