﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_HIO_MANAGER_H_
#define NW_SND_EDIT_HIO_MANAGER_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#if defined(NW_PLATFORM_CAFE)
#include <cafe/fs.h>
#endif

#include <nw/ut/ut_LinkList.h>
#include <nw/snd/edit/hio/sndedit_HioChannel.h>


#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_suppress 1301 // padding inserted in struct.
#pragma diag_suppress 2530 // padding added to end of struct.
#endif
#endif

namespace nw {
namespace snd {

namespace internal {
namespace fnd {
class FileStream;
}
}

namespace edit {
namespace internal {

//---------------------------------------------------------------------------
//! @brief    HIO管理クラスです。
//!
//! @details  HIOの初期化やHIOチャンネルの管理、更新を行います。
//---------------------------------------------------------------------------
class HioManager
{
private:
    typedef ut::LinkList<HioChannel::Reference, offsetof(HioChannel::Reference, node)> HioChannelRefList;

public: // コンストラクタ
    HioManager();

public:
#if defined(NW_PLATFORM_CAFE)
    //! @brief  初期化します。
    //! @param fsClient TBD
    //! @return TBD
    bool Initialize(FSClient* fsClient = NULL);
#else
    bool Initialize();
#endif

    //! @brief  終了処理を行います。
    void Finalize();

    //! @brief  初期化の有無を取得します。
    //! @return TBD
    bool IsInitialized() const { return m_IsInitialized; }

    //! @brief  ファイルを開くのに必要なメモリサイズを取得します。
    //! @return TBD
    static u32 GetRequiredMemorySizeForOpenFile();

    //! @brief  チャンネルを登録します。
    //! @param channel TBD
    void RegisterChannel(HioChannel& channel);

    //! @brief  チャンネルの登録を解除します。
    //! @param channel TBD
    void UnregisterChannel(HioChannel& channel);

    //! @brief  更新します。
    //! @param withAsyncChannels TBD
    void Update(bool withAsyncChannels = true);

#if defined(NW_PLATFORM_CAFE)
    //! @brief  ファイルを開きます。
    //! @param buffer TBD
    //! @param bufferLength TBD
    //! @param filePath TBD
    //! @param fsCmdBlock TBD
    //! @return TBD
    snd::internal::fnd::FileStream* OpenFile(void* buffer, u32 bufferLength, const char* filePath, FSCmdBlock* fsCmdBlock);
#else
    snd::internal::fnd::FileStream* OpenFile(void* buffer, u32 bufferLength, const char* filePath);
#endif

private: // メソッド
    bool Polling(bool withAsyncChannels);

    //! @brief  すべての非同期チャンネルを更新します。
    void UpdateAsyncChannels();

private: // メンバ変数
    HioChannelRefList m_ChannelRefs;        //!< HIOチャンネル参照リストです。

#if defined(NW_PLATFORM_CAFE)
    FSClient* m_FsClient;
#endif

    bool m_IsInitialized;
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#if defined(NW_PLATFORM_CTR)
#if NN_CURRENT_VERSION_NUMBER >= NN_VERSION_NUMBER(4,0,0,0)
#pragma diag_default 1301 // padding inserted in struct.
#pragma diag_default 2530 // padding added to end of struct.
#endif
#endif

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_HIO_MANAGER_H_
