﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_EDIT_HIO_ASYNC_CHANNEL_H_
#define NW_SND_EDIT_HIO_ASYNC_CHANNEL_H_

#include <nw/snd/snd_Config.h>
#ifdef NW_SND_CONFIG_ENABLE_DEV

#include <nw/ut/ut_LinkList.h>
#include <nw/snd/edit/hio/sndedit_HioChannel.h>
#include <nw/snd/edit/hio/sndedit_HioMessageHandler.h>

namespace nw {
namespace snd {
namespace edit {
namespace internal {

class HioManager;

//---------------------------------------------------------------------------
//! @brief    HIO非同期チャンネルを示すクラスです。
//!
//! @details  複数のHIOメッセージハンドラを管理するとともに、
//!           指定チャンネルに流れてきたパケットを適合したハンドラに処理を振り分けます。
//---------------------------------------------------------------------------
class HioAsyncChannel : public HioChannel
{
private:
    typedef ut::LinkList<HioMessageHandler::Reference, offsetof(HioMessageHandler::Reference, node)> HioMessageHandlerRefList;

public:
    /* ctor */ HioAsyncChannel() { }
    /* dtor */ virtual ~HioAsyncChannel() { }

public:
    //! @brief  非同期チャンネルかどうかを取得します。
    //! @return true を返します。
    virtual bool IsAsync() const { return true; }

    //! @brief  HIO メッセージハンドラを登録します。
    //! @param[in] handler HIO メッセージハンドラです。
    void RegisterMessageHandler(HioMessageHandler& handler);

    //! @brief  HIO メッセージハンドラの登録を削除します。
    //! @param[in] handler HIO メッセージハンドラです。
    void UnregisterMessageHandler(HioMessageHandler& handler);

    //! @brief  HIO チャンネルを更新します。
    //! @return 結果を返します。
    HioResult Update();

    //! @brief  HIO パケットを非同期送信します。
    //! @param[in] message 送信するパケットです。
    //! @return 結果を返します。
    HioResult Send(const HioPacket& message);

private:
    //! @brief  指定HIOメッセージヘッダに適合するハンドラを取得します。
    HioMessageHandler* GetMessageHandler(const HioPacketHeader& header) const;

private:
    HioMessageHandlerRefList m_MessageHandlerRefs;  //!< HIOメッセージハンドラ参照リストです。
};

} // namespace nw::snd::edit::internal
} // namespace nw::snd::edit
} // namespace nw::snd
} // namespace nw

#endif // NW_SND_CONFIG_ENABLE_DEV

#endif // NW_SND_EDIT_HIO_ASYNC_CHANNEL_H_
