﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_INTERNAL_ALLOCATOR_H_
#define NW_SND_DW_INTERNAL_ALLOCATOR_H_

#include <nw/ut/ut_Memory.h>

#if defined( NW_PLATFORM_CAFE )
  #include <cafe/mem.h>
#else
  #include <winext/cafe/mem.h>
#endif

namespace nw {
namespace snd {
namespace dw {
namespace internal {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class Allocator : public nw::ut::IAllocator
{
public:
    Allocator();
    ~Allocator();

    void Initialize(void* startAddress, size_t size, u16 option = 0);
    void Finalize();

    void* GetStartAddress();
    void* GetEndAddress();

    virtual void* Alloc(size_t size, u32 alignment);
    virtual void Free(void* memory);

    using nw::ut::IAllocator::Alloc;

    size_t GetFreeSize();
    size_t GetTotalSize();
    size_t GetMemoryBlockSize(void* address);
    size_t GetAllocatableSize(u32 alignment);
    void Dump();

private:
#if defined( NW_PLATFORM_WIN32 ) || defined ( NW_USE_NINTENDO_SDK )
    typedef nw::internal::winext::MEMHeapHandle MEMHeapHandle;
#endif
    MEMHeapHandle m_HeapHandle;
};

} // namespace internal
} // namespace dw
} // namespace snd
} // namespace nw

/* NW_SND_DW_INTERNAL_ALLOCATOR_H_ */
#endif

