﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_PERFORMANCE_PANEL_H_
#define NW_SND_DW_PERFORMANCE_PANEL_H_

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/snd.h>
#include <nw/snd/dw/control/snddw_FixedLabelPeakMeter.h>

namespace nw {
namespace snd {
namespace dw {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
class PerformancePanel : public nw::internal::dw::UIElement
{
private:
    static const s32 INVALID_INDEX = -1;

    static const char* SOUNDTHREAD_CPU_LABEL;
    static const char* SOUNDTHREAD_SND_LABEL;
    static const char* SOUNDTHREAD_SNDCB_LABEL;
    static const char* SOUNDTHREAD_SNDTH_LABEL;
    static const char* SOUNDTHREAD_AUX_LABEL;
    static const char* SOUNDTHREAD_AX_LABEL;
    static const char* SOUNDTHREAD_DSP_LABEL;
    static const char* SOUNDTHREAD_SNDINT_LABEL;
    static const char* SOUNDTHREAD_AXINT_LABEL;

    enum
    {
        SOUNDTHREAD_CPU_INDEX,
        SOUNDTHREAD_SND_INDEX,
        SOUNDTHREAD_SNDCB_INDEX,
        SOUNDTHREAD_SNDTH_INDEX,
        SOUNDTHREAD_AUX_INDEX,
        SOUNDTHREAD_AX_INDEX,
        SOUNDTHREAD_DSP_INDEX,
        SOUNDTHREAD_SNDINT_INDEX,
        SOUNDTHREAD_AXINT_INDEX,
        PERFORMANCE_BAR_COUNT
    };

    static const s32 LABEL_LENGTH = 32;

    //---------------------------------------------------------------------------
    //! @briefprivate
    //---------------------------------------------------------------------------
    struct ProfileData
    {
        nw::ut::TimeSpan axFrame;
        nw::ut::TimeSpan axFrameInterval;
        nw::ut::TimeSpan auxProcessing;
        nw::ut::TimeSpan userCallback;
        nw::ut::TimeSpan sndFrame;
        nw::ut::TimeSpan sndFrameInterval;
        nw::ut::TimeSpan dspFrame;
        u32 axNumVoices;
    };

public:
    PerformancePanel();

public:
    bool IsVideoFrameProfile()
    {
        return m_IsVideoFrameProfile;
    }

protected:
    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    void SetProfileMode(bool isVideoFrameProfile)
    {
        m_IsVideoFrameProfile = isVideoFrameProfile;
    }
    bool IsPressWindowControlKey(const nw::dev::Pad& pad) const;

#if defined( NW_PLATFORM_CAFE )
    void UpdateVideoFrameProfiles(const nw::snd::SoundProfile* pProfile, u32 profileCount);
    void UpdateAudioFrameProfiles(const nw::snd::SoundProfile* pProfile, u32 profileCount);
#endif
    void SetMeter(int index, f32 value);

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<PERFORMANCE_BAR_COUNT> m_Container;

    internal::FixedLabelPeakMeter<LABEL_LENGTH> m_PerformanceMeters[PERFORMANCE_BAR_COUNT];

    bool m_IsVideoFrameProfile;

#if defined ( NW_PLATFORM_CAFE )
    ProfileReader m_ProfileReader;
    nw::ut::Tick  m_PrevAxFrameProcessBegin;
    nw::ut::Tick  m_PrevNwFrameProcessBegin;
#endif

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "PerformancePanel";
    }
#endif
};

} // dw
} // snd
} // nw

#endif // NW_SND_DW_PERFORMANCE_PANEL_H_
