﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_SND_DW_INTERNAL_FIXED_LABEL_PEAK_METER_H_
#define NW_SND_DW_INTERNAL_FIXED_LABEL_PEAK_METER_H_

#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedDockPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/snd/dw/control/snddw_PeakMeter.h>

namespace nw {
namespace snd {
namespace dw {
namespace internal {

//---------------------------------------------------------------------------
//! @briefprivate
//---------------------------------------------------------------------------
template<int TTextLength>
class FixedLabelPeakMeter : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

    static const char* VALUE_FORMAT;

public:
    FixedLabelPeakMeter();

public:
    nw::internal::dw::Orientation GetOrientation() const;
    void SetOrientation(nw::internal::dw::Orientation value);

    const char* GetLabelText() const;
    void SetLabelText(const char* value);

    float GetValue() const;
    void SetValue(float value);

    float GetPeakValue() const;

    const char* GetValueFormat() const;
    void SetValueFormat(const char* value);

    float GetMinimumValue() const;
    void SetMinimumValue(float value);

    float GetMaximumValue() const;
    void SetMaximumValue(float value);

    float GetPeakHoldChange() const;
    void SetPeakHoldChange(float value);

    float GetPeakHoldFrames() const;
    void SetPeakHoldFrames(float value);

    const nw::ut::Color4f GetBarColor() const;
    void SetBarColor(const nw::ut::Color4f& value);

protected:
    virtual void OnUpdate(const nw::internal::dw::UIElementTreeContext& context)
    {
        (void)context;
        static const u32 LABEL_LENGTH = 32;
        static char labelText[LABEL_LENGTH];

        // 値のテキストを設定します。
        nw::ut::snprintf(
            labelText,
            LABEL_LENGTH,
            LABEL_LENGTH - 1,
            m_pValueFormat,
            m_PeakMeter.GetValue());

        m_ValueLabel.SetText(labelText);

        // ピーク値のテキストを設定します。
        nw::ut::snprintf(
            labelText,
            LABEL_LENGTH,
            LABEL_LENGTH - 1,
            m_pValueFormat,
            m_PeakMeter.GetPeakValue());

        m_PeakValueLabel.SetText(labelText);

        // オーバーフロー時はテキスト色を変更します。
        m_ValueLabel.SetTextColor(
            m_PeakMeter.IsValueInRange() ? nw::ut::Color4f::WHITE() : nw::ut::Color4f(0.8f, 0.3f, 0.3f, 1.f));

        m_PeakValueLabel.SetTextColor(
            m_PeakMeter.IsPeakValueInRange() ? nw::ut::Color4f::WHITE() : nw::ut::Color4f(0.8f, 0.3f, 0.3f, 1.f));
    }

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<7> m_Container;
    nw::internal::dw::FixedLabel<TTextLength> m_Label;
    nw::internal::dw::FixedLabel<TTextLength> m_Label2;
    nw::internal::dw::FixedLabel<TTextLength> m_ValueLabel;
    nw::internal::dw::FixedLabel<TTextLength> m_Label3;
    nw::internal::dw::FixedLabel<TTextLength> m_PeakValueLabel;
    nw::internal::dw::FixedLabel<TTextLength> m_Label4;
    PeakMeter m_PeakMeter;

    const char* m_pValueFormat;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
private:
    static const u32 DEBUG_TEXT_LENGTH = 32;

public:
    virtual const char* ToString() const
    {
        ut::snprintf(
            const_cast<char*>(m_DebugText),
            sizeof(m_DebugText),
            sizeof(m_DebugText) - 1,
            "FixedLabelPeakMeter<%d>",
            TTextLength);
        return m_DebugText;
    }

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];
#endif
};


} // internal
} // dw
} // snd
} // nw

#include "nw/snd/dw/control/snddw_FixedLabelPeakMeter.hpp"

#endif // NW_SND_DW_INTERNAL_FIXED_LABEL_PEAK_METER_H_
