﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_MCS_SIMPLERINGBUFFER_H_
#define NW_MCS_SIMPLERINGBUFFER_H_

#if (defined(_MSC_VER) && _MSC_VER > 1000) || defined(__CWCC__)
#pragma once
#endif

#include <nw/types.h>

#if defined(NW_MCS_ENABLE)

#include <nw/ut/os/ut_Mutex.h>

namespace nw
{
namespace mcs
{
namespace internal
{

//---------------------------------------------------------
struct SimpleDataRange
{
    u32     start;
    u32     end;
};

//---------------------------------------------------------
struct SimpleRingBufferHeader
{
    u32                           bufSize;
    SimpleDataRange               dataRange;
    nw::ut::Mutex                 mutex;
};

//---------------------------------------------------------------------------
//! @brief        デフォルトコンストラクタです。
//!
//!  Ring buffer for storing data divided into each channel (ChannelInfo)
//!
//!  Note that HioRingBuffer is unrelated to the class hierarchy.
//---------------------------------------------------------------------------
class SimpleRingBuffer
{
public:
    //---------------------------------------------------------------------------
    //! @brief        デフォルトコンストラクタです。
    //---------------------------------------------------------------------------
                            SimpleRingBuffer() {}

    //---------------------------------------------------------------------------
    //! @brief        インスタンスを初期化します。
    //---------------------------------------------------------------------------
    void                    Init(
                                void*   buf,
                                u32     size);

    //---------------------------------------------------------------------------
    //! @brief        現在バッファにあるデータを破棄します。
    //---------------------------------------------------------------------------
    void                    Discard();

    //---------------------------------------------------------------------------
    //! @brief        読み込み可能なデータサイズを取得します。
    //---------------------------------------------------------------------------
    u32                     GetReadableBytes();

    //---------------------------------------------------------------------------
    //! @brief        書き込み可能なデータサイズを取得します。
    //---------------------------------------------------------------------------
    u32                     GetWritableBytes();

    //---------------------------------------------------------------------------
    //! @brief        リングバッファから読み出します。
    //---------------------------------------------------------------------------
    u32                     Read(
                                void*       buf,
                                u32         size);

    void                    BeginRead(SimpleDataRange* pDataRange);

    u32                     ContinueRead(
                                SimpleDataRange*    pDataRange,
                                void*               buf,
                                u32                 size);

    void                    EndRead(const SimpleDataRange& dataRange);

    //---------------------------------------------------------------------------
    //! @brief        リングバッファへ書き込みます。
    //---------------------------------------------------------------------------
    u32                     Write(
                                const void*     buf,
                                u32             size);

    void                    BeginWrite(SimpleDataRange* pDataRange);

    u32                     ContinueWrite(
                                SimpleDataRange*    pDataRange,
                                const void*         buf,
                                u32                 size);

    void                    EndWrite(const SimpleDataRange& dataRange);

private:
    SimpleRingBufferHeader*     m_pHeader;
};

}   // namespace internal
}   // namespace mcs
}   // namespace nw

#endif  // #if defined(NW_MCS_ENABLE)

/* NW_MCS_SIMPLERINGBUFFER_H_ */
#endif
