﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_G3D_RES_DEFS_H_
#define NW_G3D_RES_DEFS_H_

#include <nw/g3d/g3d_config.h>


// リソースクラスのポインタからリソース名を取得するマクロです。
#define NW_G3D_RES_GET_NAME(pRes, get_func)    \
    (pRes)==NULL?"":(pRes)->get_func


// リソース実装のためのマクロ群

#define NW_G3D_RES_ASSERT_INDEX(name, idx) NW_G3D_ASSERT_INDEX_BOUNDS(idx, Get##name##Count())


// get_func には名前取得の関数名を指定します。
#define NW_G3D_RES_ASSERT_INDEX_DETAIL(name, idx, get_func)                                     \
    NW_G3D_ASSERT_INDEX_BOUNDS_DETAIL(idx, Get##name##Count(), "%s\n", get_func)                \


#define NW_G3D_RES_DIC(offset) ResDicType::ResCast(offset.to_ptr<ResDicType::DataType>())


#define NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL(name)                                                 \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_DETAIL(name, "")

#define NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_WITH_FUNCNAME(funcName, name)                         \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_DETAIL_WITH_FUNCNAME(funcName, name, "")

#define NW_G3D_RES_FIELD_DIC_LOOKUP_DECL(type, name)                                               \
    /*! @brief name の 数を取得します。 */                                                         \
    int Get##name##Count() const { return ref().num##name; }                                       \
    /*! @brief 指定した名前の name を取得します。 */                                               \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    type* Get##name(const char* str)                                                               \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief 指定した名前の name を取得します。 */                                               \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    type* Get##name(const ResName* str)                                                            \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const type* Get##name(const char* str) const                                                   \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const type* Get##name(const ResName* str) const                                                \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    type* Find##name(const char* str)                                                              \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    type* Find##name(const ResName* str)                                                           \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const type* Find##name(const char* str) const                                                  \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const type* Find##name(const ResName* str) const                                               \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL(name)                                                     \

#define NW_G3D_RES_FIELD_DIC_LOOKUP_DECL_WITH_FUNCNAME(type, funcName, name)                       \
    /*! @brief name の 数を取得します。 */                                                         \
    int Get##funcName##Count() const { return ref().num##name; }                                   \
    /*! @brief 指定した名前の name を取得します。 */                                               \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    type* Get##funcName(const char* str)                                                           \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief 指定した名前の name を取得します。 */                                               \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    type* Get##funcName(const ResName* str)                                                        \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const type* Get##funcName(const char* str) const                                               \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const type* Get##funcName(const ResName* str) const                                            \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    type* Find##funcName(const char* str)                                                          \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    type* Find##funcName(const ResName* str)                                                       \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const type* Find##funcName(const char* str) const                                              \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const type* Find##funcName(const ResName* str) const                                           \
    {                                                                                              \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str);                               \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_WITH_FUNCNAME(funcName, name)                             \

#define NW_G3D_RES_FIELD_DIC_DECL_DETAIL(type, name, get_func)                                     \
    NW_G3D_RES_FIELD_DIC_LOOKUP_DECL(type, name)                                                   \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    type* Get##name(int elemIndex)                                                                 \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Get(elemIndex);                          \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const type* Get##name(int elemIndex) const                                                     \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        void* ptr = NW_G3D_RES_DIC(ref().ofs##name##Dic)->Get(elemIndex);                          \
        return type::ResCast(static_cast<type##Data*>(ptr));                                       \
    }                                                                                              \

#define NW_G3D_RES_FIELD_DIC_DECL(type, name)                                                      \
    NW_G3D_RES_FIELD_DIC_DECL_DETAIL(type, name, "")


#define NW_G3D_RES_FIELD_STR_DIC_DECL(name)                                                        \
    NW_G3D_RES_FIELD_STR_DIC_DECL_DETAIL(name, "")


#define NW_G3D_RES_FIELD_EMPTY_DIC_DECL(name)                                                      \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL(name)                                                     \
    /*! @brief name の 数を取得します。 */                                                         \
    int Get##name##Count() const { return ref().num##name; }                                       \


// 配列から指定されたインデックスの type を返す
// 範囲外のインデックスを指定された場合はアサートする
#define NW_G3D_RES_FIELD_CLASS_ARRAY_DECL(type, name)                                              \
    NW_G3D_RES_FIELD_CLASS_ARRAY_DECL_DETAIL(type, name, "")


#define NW_G3D_RES_FIELD_CLASS_NAMED_ARRAY_DECL(type, name)                                        \
    NW_G3D_RES_FIELD_CLASS_NAMED_ARRAY_DECL_DETAIL(type, name, "")                               \


#define NW_G3D_RES_FIELD_CLASS_DECL(type, name)                                                    \
    /*! @brief name を取得します。 */                                                              \
    type* Get##name() { return type::ResCast(ref().ofs##name.to_ptr<type##Data>()); }              \
    /*! @brief name を取得します。 */                                                              \
    const type* Get##name() const { return type::ResCast(ref().ofs##name.to_ptr<type##Data>()); }  \


#define NW_G3D_RES_FIELD_DEREFERENCE_DECL(type)                                                    \
    /*! @brief 参照解決した type を取得します。 */                                                 \
    Res##type* Get() { return Res##type::ResCast(ref().ofsRefData.to_ptr<Res##type##Data>()); }    \
    /*! @brief 参照解決した type を取得します。 */                                                 \
    const Res##type* Get() const                                                                   \
    {                                                                                              \
        return Res##type::ResCast(ref().ofsRefData.to_ptr<Res##type##Data>());                     \
    }                                                                                              \


#define NW_G3D_RES_FIELD_STRING_DECL(name)                                                         \
    /*! @brief name を取得します。 */                                                              \
    const char* Get##name() const { return ref().ofs##name.to_ptr(); }                             \


#define NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_DETAIL(name, get_func)                                \
    /*! @brief 指定した名前の name のインデクスを取得します。 */                                   \
    /*! @details 指定した名前の name が無い場合は -1 を返します。 */                               \
    int Get##name##Index(const char* str) const                                                    \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief 指定した名前の name のインデクスを取得します。 */                                   \
    /*! @details 指定した名前の name が無い場合は -1 を返します。 */                               \
    int Get##name##Index(const ResName* str) const                                                 \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief Get##name##Index() の別名関数です。 */                                              \
    int Find##name##Index(const char* str) const                                                   \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief Get##name##Index() の別名関数です。 */                                              \
    int Find##name##Index(const ResName* str) const                                                \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief name のインデクスから名前を取得します。 */                                          \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const char* Get##name##Name(int elemIndex) const                                               \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->GetName(elemIndex);                           \
    }                                                                                              \

#define NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_DETAIL_WITH_FUNCNAME(funcName, name, get_func)        \
    /*! @brief 指定した名前の name のインデクスを取得します。 */                                   \
    /*! @details 指定した名前の name が無い場合は -1 を返します。 */                               \
    int Get##funcName##Index(const char* str) const                                                \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief 指定した名前の name のインデクスを取得します。 */                                   \
    /*! @details 指定した名前の name が無い場合は -1 を返します。 */                               \
    int Get##funcName##Index(const ResName* str) const                                             \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief Get##name##Index() の別名関数です。 */                                              \
    int Find##funcName##Index(const char* str) const                                               \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief Get##name##Index() の別名関数です。 */                                              \
    int Find##funcName##Index(const ResName* str) const                                            \
    {                                                                                              \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->FindIndex(str);                               \
    }                                                                                              \
    /*! @brief name のインデクスから名前を取得します。 */                                          \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const char* Get##funcName##Name(int elemIndex) const                                           \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        return NW_G3D_RES_DIC(ref().ofs##name##Dic)->GetName(elemIndex);                           \
    }                                                                                              \

#define NW_G3D_RES_FIELD_STR_DIC_DECL_DETAIL(name, get_func)                                       \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL(name)                                                     \
    /*! @brief name の 数を取得します。 */                                                         \
    int Get##name##Count() const { return ref().num##name; }                                       \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const char* Get##name(const char* str) const                                                   \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const char* Get##name(const ResName* str) const                                                \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const char* Find##name(const char* str) const                                                  \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const char* Find##name(const ResName* str) const                                               \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const char* Get##name(int elemIndex) const                                                     \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Get(elemIndex));     \
    }                                                                                              \

#define NW_G3D_RES_FIELD_STR_DIC_DECL_DETAIL_WITH_FUNCNAME(funcName, name, get_func)               \
    NW_G3D_RES_FIELD_DIC_LOOKUP_IDX_DECL_WITH_FUNCNAME(funcName, name)                             \
    /*! @brief name の 数を取得します。 */                                                         \
    int Get##funcName##Count() const { return ref().num##name; }                                   \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const char* Get##funcName(const char* str) const                                               \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief 名前引きで name を取得します。 */                                                   \
    /*! @details 指定した名前の name が無い場合は NULL を返します。 */                             \
    const char* Get##funcName(const ResName* str) const                                            \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const char* Find##funcName(const char* str) const                                              \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief Get##name##() の別名関数です。 */                                                   \
    const char* Find##funcName(const ResName* str) const                                           \
    {                                                                                              \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Find(str));          \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const char* Get##funcName(int elemIndex) const                                                 \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        return static_cast<const char*>(NW_G3D_RES_DIC(ref().ofs##name##Dic)->Get(elemIndex));     \
    }

// 配列から指定されたインデックスの type を返す
// 範囲外のインデックスを指定された場合はアサートする
#define NW_G3D_RES_FIELD_CLASS_ARRAY_DECL_DETAIL(type, name, get_func)                             \
    /*! @brief name の数を取得します */                                                            \
    int Get##name##Count() const { return ref().num##name; }                                       \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    type* Get##name(int elemIndex)                                                                 \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                          \
        return type::ResCast(&pArray[elemIndex]);                                                  \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const type* Get##name(int elemIndex) const                                                     \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        const type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                    \
        return type::ResCast(const_cast<type##Data*>(&pArray[elemIndex]));                         \
    }                                                                                              \

#define NW_G3D_RES_FIELD_CLASS_ARRAY_DECL_DETAIL_WITH_FUNCNAME(type, funcName, name, get_func)     \
    /*! @brief name の数を取得します */                                                            \
    int Get##funcName##Count() const { return ref().num##name; }                                   \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    type* Get##funcName(int elemIndex)                                                             \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                          \
        return type::ResCast(&pArray[elemIndex]);                                                  \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const type* Get##funcName(int elemIndex) const                                                 \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        const type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                    \
        return type::ResCast(const_cast<type##Data*>(&pArray[elemIndex]));                         \
    }                                                                                              \

#define NW_G3D_RES_FIELD_CLASS_NAMED_ARRAY_DECL_DETAIL(type, name, get_func)                       \
    NW_G3D_RES_FIELD_DIC_LOOKUP_DECL(type, name)                                                   \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    type* Get##name(int elemIndex)                                                                 \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                          \
        return type::ResCast(&pArray[elemIndex]);                                                  \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const type* Get##name(int elemIndex) const                                                     \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        const type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                    \
        return type::ResCast(const_cast<type##Data*>(&pArray[elemIndex]));                         \
    }                                                                                              \

#define NW_G3D_RES_FIELD_CLASS_NAMED_ARRAY_DECL_DETAIL_WITH_FUNCNAME(type, funcName, name, get_func) \
    NW_G3D_RES_FIELD_DIC_LOOKUP_DECL_WITH_FUNCNAME(type, funcName, name)                           \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    type* Get##funcName(int elemIndex)                                                             \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                          \
        return type::ResCast(&pArray[elemIndex]);                                                  \
    }                                                                                              \
    /*! @brief インデクス引きで name を取得します。 */                                             \
    /*! @details 指定したインデクスの name が範囲外の場合は ASSERT します。 */                     \
    const type* Get##funcName(int elemIndex) const                                                 \
    {                                                                                              \
        NW_G3D_RES_ASSERT_INDEX_DETAIL(name, elemIndex, get_func);                                 \
        const type##Data* pArray = ref().ofs##name##Array.to_ptr<type##Data>();                    \
        return type::ResCast(const_cast<type##Data*>(&pArray[elemIndex]));                         \
    }                                                                                              \

#endif // NW_G3D_RES_DEFS_H_
