﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//---------------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------------
#include <nw/eft/eftcom_Guid.h>
#include <nw/eft/eft2_EndianUtil.h>


namespace nw     {
namespace eftcom {

//---------------------------------------------------------------------------------------------
//! @brief      メッセージタイプです.
//---------------------------------------------------------------------------------------------
enum MESSAGE_TYPE
{
    MESSAGE_TYPE_CONTROL = 1,                   //!< 制御用データです.
    MESSAGE_TYPE_SEND_BINARY,                   //!< バイナリ転送を通知するメッセージです.
    MESSAGE_TYPE_CREATE,                        //!< インスタンスを生成を通知するメッセージです.
    MESSAGE_TYPE_MODIFY,                        //!< リアルタイム編集を通知するメッセージです.
    MESSAGE_TYPE_DELETE,                        //!< インスタンスを削除を通知するメッセージです.
    MESSAGE_TYPE_REMOVE_BINARY,                 //!< バイナリ削除を通知するメッセージです.
    MESSAGE_TYPE_MODEL_INFO,                    //!< モデルデータを送信するメッセージです。
    MESSAGE_TYPE_ESET_REQUEST,                  //!< エミッタセットリクエストを送信するメッセージです。
    MESSAGE_TYPE_FORCE_4BYTE = 0xFFFFFFFF       //!< TBD
};


//---------------------------------------------------------------------------------------------
//! @brief      アセットタイプです.
//---------------------------------------------------------------------------------------------
enum ASSET_TYPE
{
    ASSET_TYPE_EMITTERSET = 0,                  //!< エミッタセットです.
    ASSET_TYPE_EMITTER,                         //!< エミッタです.
    ASSET_TYPE_TEXTURE,                         //!< テクスチャです.
    ASSET_TYPE_PRIMITIVE,                       //!< プリミティブです.
    ASSET_TYPE_SHADER,                          //!< シェーダです.
    ASSET_TYPE_PREVIEW,                         //!< プレービューです.
    ASSET_TYPE_VIEWER_DATA,                     //!< ビューアデータです.
    ASSET_TYPE_VIEWER_MODEL,                    //!< ビューアモデルです.
    ASSET_TYPE_VIEWER_MESSAGE,                  //!< ビューアメッセージです.
    ASSET_TYPE_FORCE_4BYTE = 0xFFFFFFFF         //!< TBD
};


//--------------------------------------------------------------------------------------------
//! @brief      ビューアメッセージタイプです.
//--------------------------------------------------------------------------------------------
enum VIEWER_MESSAGE_TYPE
{
    VIEWER_MESSAGE_TYPE_CONFIG = 0,             //!< ビューア初期設定.
    VIEWER_MESSAGE_TYPE_RESETFRAME,             //!< フレームを先頭に戻します.
    VIEWER_MESSAGE_TYPE_PLAY,                   //!< 再生します.
    VIEWER_MESSAGE_TYPE_PAUSE,                  //!< 一時停止します.
    VIEWER_MESSAGE_TYPE_STOP,                   //!< 停止します.
    VIEWER_MESSAGE_TYPE_STEPFRAME,              //!< 1フレーム進めます.
    VIEWER_MESSAGE_TYPE_FORCEFADE,              //!< 強制フェードします.
    VIEWER_MESSAGE_TYPE_SETRANGE,               //!< 再生範囲を設定します.
    VIEWER_MESSAGE_TYPE_CAMERA,                 //!< カメラデータを設定します.
    VIEWER_MESSAGE_TYPE_BACKGROUND_IMAGE,       //!< 背景画像を設定します.
    VIEWER_MESSAGE_TYPE_REQUEST_TO_EDITOR,      //!< エディタへの要求パケット.
    VIEWER_MESSAGE_TYPE_VISIBILITY,             //!< 表示/非表示の切り替え.
    VIEWER_MESSAGE_TYPE_APP_INITIALIZED,        //!< アプリケーションの初期化完了を通知するメッセージです.
    VIEWER_MESSAGE_TYPE_DRAW_ORDER,             //!< 描画順を設定します.
    VIEWER_MESSAGE_TYPE_FORCE_4BYTE = 0xFFFFFFFF//!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      モデルメッセージタイプです.
//--------------------------------------------------------------------------------------------
enum MODEL_MESSAGE_TYPE
{
    MODEL_MESSAGE_TYPE_CLEAR_PREVIEWMODEL = 0,  //!< モデル情報の削除を通知するメッセージです。
    MODEL_MESSAGE_TYPE_BEGIN_SENDMODELINFO,     //!< モデル情報の送信開始を通知するメッセージです.
    MODEL_MESSAGE_TYPE_SEND_MODELINFO,          //!< モデル情報の送信するメッセージです.
    MODEL_MESSAGE_TYPE_END_SEND_MODELINFO,      //!< モデル情報の送信終了を通知するメッセージです.
    MODEL_MESSAGE_TYPE_FORCE_4BYTE = 0xFFFFFFFF //!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      ビューアメッセージタイプです.
//--------------------------------------------------------------------------------------------
enum REQUEST_ESET_MESSAGE_TYPE
{
    ESET_MESSAGE_TYPE_REQUEST_FILE_OPEN = 0,                //!< TBD
    ESET_MESSAGE_TYPE_REQUEST_CLOSE,                        //!< TBD
    ESET_MESSAGE_TYPE_REQUEST_CREATE,                       //!< TBD
    ESET_MESSAGE_TYPE_REQUEST_DUPLICATE,                    //!< TBD
    ESET_MESSAGE_TYPE_REQUEST_LINKESET,                     //!< TBD
    ESET_MESSAGE_TYPE_REQUEST_UNLINKESET,                   //!< TBD
    ESET_MESSAGE_TYPE_REQUEST_FORCE_4BYTE = 0xFFFFFFFF      //!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      バイナリ転送メッセージです.
//--------------------------------------------------------------------------------------------
struct SendBinaryMessage
{
    unsigned int        assetType;      //!< アセットタイプです.
    Guid                guid;           //!< アセットのGUIDです.
};


//--------------------------------------------------------------------------------------------
//! @brief      インスタンス生成メッセージです.
//--------------------------------------------------------------------------------------------
struct CreateMessage
{
    unsigned int        assetType;      //!< アセットタイプです.
    Guid                resGuid;        //!< リソースのGUIDです.
    Guid                previewGuid;    //!< プレビューのGUIDです.
};


//--------------------------------------------------------------------------------------------
//! @brief      インスタンス削除メッセージです.
//--------------------------------------------------------------------------------------------
struct DeleteMessage
{
    unsigned int        assetType;      //!< アセットタイプです.
    Guid                resGuid;        //!< リソースのGUIDです.
    Guid                previewGuid;    //!< プレビューのGUIDです.
};


//--------------------------------------------------------------------------------------------
//! @brief      バイナリ削除メッセージです.
//--------------------------------------------------------------------------------------------
struct RemoveBinaryMessage
{
    unsigned int        assetType;      //!< アセットタイプです.
    Guid                guid;           //!< アセットのGUIDです.
};

//--------------------------------------------------------------------------------------------
//! @brief      データ変更メッセージです.
//--------------------------------------------------------------------------------------------
struct ModifyMessage
{
    unsigned int        assetType;      //!< アセットタイプです.
    Guid                guid;           //!< アセットのGUIDです.
    unsigned int        offset;         //!< データオフセットです.
    unsigned int        overrideSize;   //!< 上書きするデータサイズです.
    unsigned short      isRequiredReset;//!< リセットが必要かどうか.
    unsigned short      endian;         //!< 対象スペックのCPUエンディアン.
    char                emitterName[64];//!< ※暫定
};


//--------------------------------------------------------------------------------------------
//! @brief TBD
//--------------------------------------------------------------------------------------------
enum
{
    max_modelName = 260 * 2,    //!< TBD
    max_esetName  = 260 * 2     //!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      ビューアヘッダーのメッセージです。
//--------------------------------------------------------------------------------------------
struct ViewerHeaderMessage
{
    u32 type;        //!< TBD
    u32 size;        //!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      モデルヘッダーのメッセージです。
//--------------------------------------------------------------------------------------------
struct ModelHeaderMessage
{
    u32 type;        //!< TBD
    u32 size;        //!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      モデルデータのメッセージです。
//--------------------------------------------------------------------------------------------
struct ModelDataMessage
{
    Guid modelGuid;                    //!< モデルノードID
    u32  isGame;                       //!< Game接続かどうか
    char modelName[max_modelName];     //!< モデル名
    u32  boneCount;                    //!< ボーン数
    u32  boneDataSize;                 //!< ボーンデータサイズ
    char boneData;                     //!< データ
};

//--------------------------------------------------------------------------------------------
//! @brief      エミッタセットリクエストヘッダーのメッセージです。
//--------------------------------------------------------------------------------------------
struct EsetRequestHeaderMessage
{
    u32 type;    //!< TBD
    u32 size;    //!< TBD
};

//--------------------------------------------------------------------------------------------
//! @brief      エミッタセットリクエストのメッセージです。
//--------------------------------------------------------------------------------------------
struct EsetRequestMessage
{
    char emitterSetName[max_esetName];       //!< エミッタセット名
    char dupEmitterSetName[max_esetName];    //!< 複製エミッタセット名
};

} // namespace eftcom
} // namesapce nw
