﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw   {
namespace eft2 {

//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere2[][3] =
{
        {0.000000f, 1.000000f,  0.000000f},
        {0.000000f, -1.000000f, 0.000000f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere3[][3] =
{
        {0.000000f, 1.000000f,  0.000000f},
        {-0.707107f,    -0.707107f, 0.000000f},
        {0.707107f, -0.707107f, 0.000000f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere4[][3] =
{
        {0.000000f, -1.000000f, 0.000000f},
        {0.471404f, 0.333333f,  0.816497f},
        {0.471404f, 0.333333f,  -0.816497f},
        {-0.942809f,    0.333333f,  0.000000f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere6[][3] =
{
        {0.000000f, 0.000000f,  1.000000f},
        {0.000000f, 1.000000f,  0.000000f},
        {0.000000f, 0.000000f,  -1.000000f},
        {0.000000f, -1.000000f, 0.000000f},
        {1.000000f, 0.000000f,  0.000000f},
        {-1.000000f,    0.000000f,  0.000000f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere8[][3] =
{
        {0.577350f, 0.577350f,  -0.577350f},
        {-0.577350f,    0.577350f,  -0.577350f},
        {-0.577350f,    0.577350f,  0.577350f},
        {0.577350f, 0.577350f,  0.577350f},
        {0.577350f, -0.577350f, -0.577350f},
        {-0.577350f,    -0.577350f, -0.577350f},
        {-0.577350f,    -0.577350f, 0.577350f},
        {0.577350f, -0.577350f, 0.577350f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere12[][3] =
{
        {0.850651f, 0.000000f,  -0.525731f},
        {0.850651f, 0.000000f,  0.525731f},
        {0.525731f, -0.850651f, 0.000000f},
        {0.000000f, -0.525731f, 0.850651f},
        {-0.525731f,    -0.850651f, 0.000000f},
        {0.000000f, -0.525731f, -0.850651f},
        {0.000000f, 0.525731f,  -0.850651f},
        {0.525731f, 0.850651f,  0.000000f},
        {0.000000f, 0.525731f,  0.850651f},
        {-0.850651f,    0.000000f,  0.525731f},
        {-0.525731f,    0.850651f,  0.000000f},
        {-0.850651f,    0.000000f,  -0.525731f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere20[][3] =
{
        {0.934172f, -0.356822f, 0.000000f},
        {0.934172f, 0.356822f,  0.000000f},
        {0.356822f, 0.000000f,  -0.934172f},
        {0.577350f, 0.577350f,  -0.577350f},
        {0.577350f, -0.577350f, -0.577350f},
        {0.356822f, 0.000000f,  0.934172f},
        {0.577350f, -0.577350f, 0.577350f},
        {0.577350f, 0.577350f,  0.577350f},
        {-0.934172f,    -0.356822f, 0.000000f},
        {-0.934172f,    0.356822f,  0.000000f},
        {-0.356822f,    0.000000f,  0.934172f},
        {-0.577350f,    -0.577350f, 0.577350f},
        {-0.577350f,    0.577350f,  0.577350f},
        {-0.356822f,    0.000000f,  -0.934172f},
        {-0.577350f,    0.577350f,  -0.577350f},
        {-0.577350f,    -0.577350f, -0.577350f},
        {0.000000f, -0.934172f, 0.356822f},
        {0.000000f, 0.934172f,  0.356822f},
        {0.000000f, 0.934172f,  -0.356822f},
        {0.000000f, -0.934172f, -0.356822f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere32[][3] =
{
        {0.188492f, 0.914958f,  -0.356822f},
        {-0.400983f,    0.914958f,  0.045431f},
        {0.193493f, 0.939234f,  0.283550f},
        {0.729968f, 0.681970f,  0.045431f},
        {-0.386986f,    0.727076f,  -0.567100f},
        {-0.223822f,    0.681970f,  0.696291f},
        {0.642851f, 0.514917f,  -0.567101f},
        {0.475144f, 0.537975f,  0.696291f},
        {-0.861296f,    0.448979f,  -0.237881f},
        {0.092495f, 0.448981f,  -0.888741f},
        {-0.762436f,    0.514917f,  0.391857f},
        {0.968623f, 0.071996f,  -0.237879f},
        {0.903875f, 0.171636f,  0.391855f},
        {-0.556309f,    0.160992f,  -0.815231f},
        {0.035359f, 0.171639f,  0.984525f},
        {-0.574642f,    0.071997f,  0.815232f},
        {0.574642f, -0.071997f, -0.815232f},
        {0.556309f, -0.160992f, 0.815231f},
        {-0.903875f,    -0.171636f, -0.391855f},
        {-0.968623f,    -0.071996f, 0.237879f},
        {-0.035359f,    -0.171639f, -0.984525f},
        {0.762436f, -0.514917f, -0.391857f},
        {0.861296f, -0.448979f, 0.237881f},
        {-0.475144f,    -0.537975f, -0.696291f},
        {-0.092495f,    -0.448981f, 0.888741f},
        {-0.642851f,    -0.514917f, 0.567101f},
        {0.223822f, -0.681970f, -0.696291f},
        {0.386986f, -0.727076f, 0.567100f},
        {-0.729968f,    -0.681970f, -0.045431f},
        {0.400983f, -0.914958f, -0.045431f},
        {-0.193493f,    -0.939234f, -0.283550f},
        {-0.188492f,    -0.914958f, 0.356822f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球のデータ
//------------------------------------------------------------------------------
static const f32 *gSameDivideSphereTbl[] =
{
    (f32*)gSameDivideSphere2  ,
    (f32*)gSameDivideSphere3  ,
    (f32*)gSameDivideSphere4  ,
    (f32*)gSameDivideSphere6  ,
    (f32*)gSameDivideSphere8  ,
    (f32*)gSameDivideSphere12 ,
    (f32*)gSameDivideSphere20 ,
    (f32*)gSameDivideSphere32 ,
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_2[][3] =
{
        {0.975795f,	-0.023205f,	0.217454f},
        {0.550744f,	-0.714038f,	-0.432240f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_3[][3] =
{
        {-0.198048f,	0.721093f,	-0.663930f},
        {0.645908f,	-0.727871f,	-0.230231f},
        {-0.447828f,	0.006775f,	0.894094f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_4[][3] =
{
        {0.676976f,	0.235577f,	0.697285f},
        {-0.030787f,	0.597098f,	-0.801577f},
        {-0.894481f,	0.075740f,	0.440643f},
        {0.248293f,	-0.908415f,	-0.336351f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_5[][3] =
{
        {0.104637f,	-0.660762f,	0.743266f},
        {-0.449743f,	0.599927f,	0.661679f},
        {0.692244f,	0.692173f,	-0.204195f},
        {0.446260f,	-0.669986f,	-0.593271f},
        {-0.793397f,	0.038647f,	-0.607477f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_6[][3] =
{
        {0.664168f,	-0.421780f,	0.617237f},
        {-0.373127f,	0.560552f,	-0.739296f},
        {0.450534f,	0.830673f,	0.327110f},
        {-0.520176f,	-0.853162f,	-0.039137f},
        {0.550231f,	-0.359836f,	-0.753501f},
        {-0.771637f,	0.243549f,	0.587589f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_7[][3] =
{
        {0.839586f,	0.141701f,	0.524420f},
        {-0.698780f,	-0.328924f,	-0.635228f},
        {0.260453f,	0.662019f,	-0.702777f},
        {-0.170786f,	0.911017f,	0.375340f},
        {-0.849687f,	-0.006727f,	0.527244f},
        {0.553175f,	-0.542239f,	-0.632435f},
        {0.066040f,	-0.836844f,	0.543444f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_8[][3] =
{
        {0.635766f,	-0.766206f,	-0.093430f},
        {0.386336f,	-0.192667f,	0.902011f},
        {-0.251218f,	0.894362f,	0.370143f},
        {0.822801f,	0.566832f,	0.041221f},
        {-0.740675f,	-0.221564f,	0.634279f},
        {-0.491542f,	-0.795375f,	-0.354634f},
        {0.356445f,	0.119167f,	-0.926686f},
        {-0.717913f,	0.395452f,	-0.572904f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_9[][3] =
{
        {0.804014f,	-0.249270f,	-0.539838f},
        {-0.169136f,	-0.384242f,	-0.907608f},
        {-0.241015f,	0.920776f,	0.306731f},
        {0.167730f,	0.745878f,	-0.644618f},
        {-0.643478f,	0.084902f,	0.760742f},
        {-0.322445f,	-0.886105f,	0.332937f},
        {0.633979f,	-0.609913f,	0.475476f},
        {-0.941196f,	-0.061188f,	-0.332276f},
        {0.711575f,	0.439172f,	0.548443f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_10[][3] =
{
        {0.761440f,	-0.259322f,	-0.594106f},
        {-0.141654f,	-0.074596f,	0.987102f},
        {-0.388960f,	0.817381f,	0.424969f},
        {-0.899619f,	-0.351896f,	0.258563f},
        {-0.275511f,	-0.474706f,	-0.835911f},
        {-0.026659f,	-0.995630f,	0.089500f},
        {0.265127f,	0.708638f,	-0.653866f},
        {0.764044f,	-0.415716f,	0.493373f},
        {-0.758287f,	0.414484f,	-0.503193f},
        {0.700079f,	0.631363f,	0.333571f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_11[][3] =
{
        {0.720108f,	-0.531505f,	-0.446035f},
        {-0.166366f,	-0.966130f,	-0.197267f},
        {0.569659f,	0.690528f,	0.445712f},
        {-0.878121f,	-0.202687f,	0.433384f},
        {-0.065675f,	-0.033182f,	-0.997289f},
        {-0.383297f,	0.877000f,	-0.289750f},
        {-0.866025f,	-0.099280f,	-0.490045f},
        {-0.044150f,	-0.576034f,	0.816233f},
        {0.652201f,	0.540154f,	-0.531852f},
        {0.808219f,	-0.278090f,	0.519084f},
        {-0.346552f,	0.579228f,	0.737832f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_12[][3] =
{
        {0.988916f,	-0.136890f,	0.057496f},
        {0.233882f,	0.642751f,	-0.729500f},
        {0.654616f,	0.754861f,	0.040785f},
        {0.337794f,	-0.409962f,	0.847246f},
        {-0.300650f,	-0.908893f,	0.289004f},
        {-0.709822f,	0.447597f,	-0.543884f},
        {-0.533057f,	0.793834f,	0.292707f},
        {-0.739948f,	-0.478366f,	-0.472909f},
        {-0.785188f,	-0.116645f,	0.608172f},
        {0.457297f,	-0.842267f,	-0.285423f},
        {0.207619f,	-0.252568f,	-0.945042f},
        {0.188540f,	0.506549f,	0.841345f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_13[][3] =
{
        {0.721712f,	0.658797f,	-0.212411f},
        {0.315862f,	0.388955f,	0.865416f},
        {0.883295f,	-0.201522f,	0.423295f},
        {-0.097345f,	0.956913f,	0.273573f},
        {-0.728711f,	0.347264f,	0.590244f},
        {0.292018f,	-0.955740f,	-0.035873f},
        {-0.896271f,	0.151778f,	-0.416727f},
        {-0.432805f,	-0.710732f,	-0.554563f},
        {0.819105f,	-0.259649f,	-0.511516f},
        {-0.758924f,	-0.552455f,	0.344715f},
        {0.089292f,	-0.041253f,	-0.995151f},
        {-0.223222f,	0.758977f,	-0.611658f},
        {0.015993f,	-0.541332f,	0.840657f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_14[][3] =
{
        {0.539580f,	-0.481359f,	-0.690758f},
        {0.569828f,	0.582544f,	-0.579602f},
        {-0.200914f,	0.442357f,	-0.874045f},
        {-0.157587f,	0.984941f,	0.071111f},
        {-0.730867f,	0.297634f,	0.614204f},
        {0.568808f,	0.673956f,	0.471423f},
        {-0.401029f,	-0.434085f,	-0.806688f},
        {-0.865304f,	0.423775f,	-0.267701f},
        {-0.863704f,	-0.503983f,	0.004099f},
        {0.038350f,	0.163371f,	0.985819f},
        {0.997552f,	-0.007574f,	-0.069514f},
        {-0.248976f,	-0.693391f,	0.676180f},
        {0.673842f,	-0.458002f,	0.579803f},
        {0.080416f,	-0.990183f,	-0.114331f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_15[][3] =
{
        {0.254310f,	0.493633f,	-0.831657f},
        {-0.843081f,	-0.429718f,	-0.323352f},
        {-0.510333f,	0.513213f,	0.690053f},
        {-0.769811f,	-0.304973f,	0.560698f},
        {-0.448619f,	0.074411f,	-0.890620f},
        {0.853359f,	-0.168683f,	-0.493280f},
        {0.832337f,	-0.097335f,	0.545657f},
        {-0.091704f,	0.988889f,	-0.117002f},
        {0.033386f,	-0.405217f,	0.913611f},
        {0.774138f,	0.629441f,	-0.067189f},
        {0.311688f,	0.598324f,	0.738145f},
        {0.563209f,	-0.813709f,	0.143782f},
        {0.142500f,	-0.630277f,	-0.763180f},
        {-0.260153f,	-0.963940f,	0.056029f},
        {-0.841225f,	0.515941f,	-0.161694f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_16[][3] =
{
        {-0.391424f,	-0.853922f,	-0.342935f},
        {-0.817970f,	0.004526f,	-0.575243f},
        {-0.248385f,	0.955612f,	0.158466f},
        {-0.371866f,	-0.102472f,	0.922613f},
        {-0.292546f,	0.712030f,	-0.638303f},
        {0.684024f,	0.240684f,	-0.688608f},
        {0.395852f,	-0.656464f,	-0.642149f},
        {0.979848f,	0.120771f,	0.159097f},
        {0.546791f,	0.832777f,	-0.086615f},
        {0.691997f,	-0.717489f,	0.079683f},
        {0.267210f,	0.557954f,	0.785676f},
        {-0.074428f,	-0.061517f,	-0.995327f},
        {0.504633f,	-0.285653f,	0.814707f},
        {-0.152858f,	-0.862706f,	0.482051f},
        {-0.798847f,	0.459375f,	0.388354f},
        {-0.922025f,	-0.343505f,	0.178533f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_17[][3] =
{
        {0.763904f,	0.639864f,	0.083813f},
        {-0.735674f,	-0.309000f,	-0.602747f},
        {0.077587f,	0.913618f,	-0.399103f},
        {-0.368332f,	-0.357900f,	0.858044f},
        {0.707965f,	-0.453448f,	0.541452f},
        {-0.221664f,	0.386565f,	0.895227f},
        {-0.075016f,	0.931998f,	0.354616f},
        {-0.878540f,	0.354861f,	0.319752f},
        {-0.060406f,	0.376432f,	-0.924473f},
        {-0.147712f,	-0.862963f,	-0.483194f},
        {0.304937f,	-0.267210f,	-0.914118f},
        {-0.801828f,	-0.568738f,	0.183326f},
        {0.687678f,	-0.688036f,	-0.231745f},
        {0.581518f,	0.230004f,	0.780343f},
        {0.022895f,	-0.921627f,	0.387400f},
        {-0.759696f,	0.486239f,	-0.431779f},
        {0.902391f,	0.109342f,	-0.416816f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_18[][3] =
{
        {0.449637f,	-0.494152f,	-0.744070f},
        {0.196958f,	0.663205f,	-0.722057f},
        {0.669128f,	0.743141f,	-0.003136f},
        {-0.598960f,	-0.642146f,	0.478431f},
        {0.732548f,	0.104503f,	0.672646f},
        {-0.272398f,	-0.082666f,	-0.958627f},
        {0.202676f,	-0.662425f,	0.721190f},
        {-0.218937f,	-0.869178f,	-0.443392f},
        {0.950627f,	-0.302515f,	0.069232f},
        {0.795143f,	0.172287f,	-0.581434f},
        {-0.306568f,	0.944492f,	0.118118f},
        {-0.717065f,	0.277473f,	0.639396f},
        {-0.820789f,	-0.477839f,	-0.313010f},
        {-0.977164f,	0.202078f,	-0.065682f},
        {0.379437f,	-0.923934f,	0.048726f},
        {-0.095224f,	0.006173f,	0.995437f},
        {-0.553252f,	0.609559f,	-0.567759f},
        {0.184205f,	0.731943f,	0.655994f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_19[][3] =
{
        {0.734232f,	0.441571f,	-0.515673f},
        {0.097158f,	-0.804392f,	-0.586100f},
        {-0.713574f,	0.689403f,	-0.124641f},
        {0.280814f,	-0.824115f,	0.491913f},
        {0.632121f,	-0.261456f,	-0.729427f},
        {0.907281f,	-0.112902f,	0.405085f},
        {0.048401f,	0.938203f,	-0.342685f},
        {-0.588184f,	-0.497854f,	-0.637323f},
        {0.124198f,	-0.181633f,	0.975492f},
        {-0.672745f,	0.278538f,	0.685442f},
        {-0.437233f,	-0.897885f,	0.051285f},
        {-0.993444f,	-0.113945f,	0.009232f},
        {-0.537648f,	-0.493465f,	0.683686f},
        {-0.184669f,	0.866415f,	0.463921f},
        {0.737932f,	0.655589f,	0.160185f},
        {0.062134f,	0.257731f,	-0.964217f},
        {-0.620040f,	0.249606f,	-0.743806f},
        {0.748897f,	-0.657489f,	-0.082836f},
        {0.374373f,	0.468078f,	0.800467f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_20[][3] =
{
        {0.569824f,	-0.815304f,	0.102858f},
        {0.087947f,	0.955731f,	-0.280790f},
        {-0.470434f,	0.875055f,	0.113891f},
        {-0.280749f,	-0.033456f,	-0.959198f},
        {0.356654f,	-0.624149f,	-0.695152f},
        {0.696323f,	-0.191309f,	0.691763f},
        {-0.432632f,	-0.660913f,	-0.613207f},
        {-0.939094f,	0.271159f,	0.211130f},
        {0.194627f,	0.498853f,	-0.844551f},
        {-0.099636f,	0.657203f,	0.747099f},
        {-0.544915f,	-0.642945f,	0.538228f},
        {0.560230f,	0.538489f,	0.629423f},
        {-0.910182f,	-0.396995f,	-0.118170f},
        {0.749630f,	0.657774f,	-0.073410f},
        {-0.520858f,	0.076850f,	0.850177f},
        {0.744081f,	0.025183f,	-0.667614f},
        {-0.117280f,	-0.992609f,	0.031185f},
        {0.987015f,	-0.160620f,	-0.001639f},
        {-0.727211f,	0.408751f,	-0.551441f},
        {0.096661f,	-0.446749f,	0.889422f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_21[][3] =
{
        {0.764973f,	0.459586f,	0.451217f},
        {0.332043f,	0.519236f,	-0.787491f},
        {0.126705f,	0.620407f,	0.773978f},
        {-0.290088f,	0.787292f,	-0.544077f},
        {-0.810184f,	-0.464714f,	-0.357271f},
        {-0.501745f,	0.131367f,	-0.854982f},
        {-0.917829f,	-0.216837f,	0.332523f},
        {0.379153f,	-0.848192f,	0.369883f},
        {-0.281454f,	-0.952039f,	-0.120023f},
        {0.935412f,	-0.353375f,	0.011430f},
        {-0.607070f,	0.306799f,	0.733035f},
        {0.308889f,	0.950906f,	-0.019091f},
        {-0.156678f,	-0.491768f,	-0.856514f},
        {0.433887f,	-0.793099f,	-0.427476f},
        {-0.061357f,	-0.169868f,	0.983555f},
        {0.894488f,	0.360561f,	-0.264361f},
        {-0.446355f,	0.863095f,	0.236292f},
        {-0.382301f,	-0.708375f,	0.593339f},
        {0.626509f,	-0.221316f,	0.747333f},
        {-0.906999f,	0.376965f,	-0.187748f},
        {0.560002f,	-0.156633f,	-0.813550f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_22[][3] =
{
        {0.835192f,	-0.381923f,	-0.395714f},
        {0.249846f,	-0.709905f,	-0.658492f},
        {0.153608f,	0.971855f,	-0.178615f},
        {0.886099f,	0.431839f,	-0.168356f},
        {-0.852486f,	-0.519106f,	0.061615f},
        {-0.418954f,	-0.863473f,	-0.280877f},
        {-0.939481f,	0.321575f,	-0.118169f},
        {0.555878f,	0.731487f,	0.394875f},
        {-0.039443f,	0.703360f,	0.709739f},
        {0.883595f,	0.024175f,	0.467627f},
        {-0.745825f,	-0.130816f,	-0.653170f},
        {-0.138962f,	-0.234992f,	-0.962013f},
        {0.364018f,	-0.042109f,	0.930440f},
        {-0.819219f,	-0.088822f,	0.566560f},
        {0.186909f,	-0.979417f,	0.076208f},
        {-0.474514f,	0.738682f,	-0.478733f},
        {0.708804f,	-0.622491f,	0.331816f},
        {-0.131964f,	-0.733979f,	0.666228f},
        {-0.298816f,	-0.049022f,	0.953051f},
        {0.612558f,	0.226932f,	-0.757149f},
        {0.017344f,	0.489413f,	-0.871880f},
        {-0.594186f,	0.716738f,	0.365007f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_23[][3] =
{
        {0.530316f,	0.598152f,	-0.600816f},
        {0.434920f,	-0.718930f,	-0.542202f},
        {0.511919f,	0.478696f,	0.713294f},
        {0.544072f,	-0.071708f,	-0.835969f},
        {-0.231777f,	0.825575f,	0.514495f},
        {0.112613f,	-0.348766f,	0.930420f},
        {0.727600f,	-0.173801f,	0.663620f},
        {-0.256565f,	0.232001f,	0.938270f},
        {-0.757051f,	0.192233f,	-0.624435f},
        {-0.174473f,	-0.437278f,	-0.882240f},
        {-0.730530f,	0.669502f,	-0.134509f},
        {-0.427307f,	-0.640076f,	0.638523f},
        {0.047400f,	-0.976376f,	0.210814f},
        {-0.899752f,	-0.297685f,	0.319108f},
        {-0.134206f,	0.907868f,	-0.397196f},
        {-0.825432f,	0.334731f,	0.454552f},
        {0.366631f,	0.919549f,	0.141460f},
        {-0.128878f,	0.336093f,	-0.932970f},
        {0.908570f,	0.417661f,	-0.007708f},
        {-0.389815f,	-0.882528f,	-0.263039f},
        {0.963753f,	-0.226615f,	-0.140803f},
        {0.640781f,	-0.736182f,	0.217798f},
        {-0.832796f,	-0.402114f,	-0.380468f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_24[][3] =
{
        {0.494847f,	0.668703f,	0.554944f},
        {0.809182f,	-0.583460f,	0.069271f},
        {-0.819156f,	0.360403f,	0.446199f},
        {-0.252663f,	-0.576808f,	-0.776823f},
        {-0.364416f,	-0.631628f,	0.684286f},
        {0.362906f,	-0.810017f,	-0.460622f},
        {0.663985f,	0.062316f,	0.745145f},
        {-0.333369f,	0.072596f,	-0.939997f},
        {-0.664192f,	-0.743152f,	-0.081081f},
        {0.425637f,	0.889766f,	-0.164769f},
        {-0.319978f,	0.289967f,	0.901961f},
        {0.984980f,	0.059425f,	0.162119f},
        {0.661965f,	-0.289422f,	-0.691403f},
        {0.338740f,	0.231305f,	-0.912005f},
        {0.109400f,	-0.179039f,	0.977741f},
        {0.842011f,	0.392760f,	-0.369807f},
        {-0.892857f,	-0.179934f,	-0.412831f},
        {-0.059785f,	0.772639f,	-0.632025f},
        {-0.551465f,	0.834047f,	0.015876f},
        {-0.890857f,	-0.259159f,	0.373108f},
        {-0.081176f,	0.898195f,	0.432038f},
        {-0.073531f,	-0.997225f,	-0.011672f},
        {-0.751619f,	0.463501f,	-0.469293f},
        {0.361411f,	-0.745780f,	0.559638f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_25[][3] =
{
        {0.809725f,	0.562869f,	0.165904f},
        {-0.562236f,	0.307922f,	-0.767512f},
        {-0.501795f,	0.837490f,	-0.216360f},
        {-0.576297f,	-0.374352f,	-0.726459f},
        {0.032466f,	0.581414f,	-0.812960f},
        {-0.108734f,	-0.968819f,	0.222636f},
        {-0.028835f,	-0.722183f,	-0.691101f},
        {0.989214f,	-0.114223f,	-0.091697f},
        {-0.927380f,	-0.115219f,	0.355938f},
        {-0.752723f,	0.568202f,	0.332498f},
        {-0.222685f,	0.680678f,	0.697917f},
        {0.684017f,	-0.390897f,	-0.615890f},
        {0.166735f,	-0.518237f,	0.838827f},
        {0.219863f,	0.931912f,	-0.288444f},
        {0.668692f,	-0.651039f,	0.359165f},
        {0.798419f,	-0.010431f,	0.602011f},
        {0.394475f,	-0.896778f,	-0.200445f},
        {-0.960387f,	0.089568f,	-0.263884f},
        {-0.532249f,	-0.595138f,	0.602098f},
        {0.313602f,	0.260578f,	0.913100f},
        {0.249964f,	0.901996f,	0.352024f},
        {-0.386113f,	0.020448f,	0.922225f},
        {0.185685f,	-0.063110f,	-0.980580f},
        {0.720884f,	0.401591f,	-0.564846f},
        {-0.674308f,	-0.724241f,	-0.144165f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_26[][3] =
{
        {0.971847f,	0.144624f,	0.186002f},
        {-0.279732f,	0.823973f,	-0.492766f},
        {-0.397538f,	-0.445977f,	-0.801915f},
        {-0.709134f,	-0.635163f,	-0.306099f},
        {-0.977305f,	-0.198511f,	0.073953f},
        {0.177758f,	-0.967440f,	-0.180170f},
        {-0.045904f,	0.993133f,	0.107612f},
        {-0.155981f,	0.253531f,	-0.954669f},
        {0.428270f,	0.006799f,	-0.903625f},
        {0.786300f,	-0.507837f,	-0.351900f},
        {-0.376615f,	-0.561077f,	0.737125f},
        {0.767605f,	-0.568257f,	0.296424f},
        {0.627234f,	0.772758f,	0.097069f},
        {-0.676689f,	0.613747f,	0.406702f},
        {-0.729114f,	-0.032713f,	0.683610f},
        {0.866888f,	0.208385f,	-0.452859f},
        {0.393185f,	0.725085f,	-0.565382f},
        {-0.192243f,	0.614804f,	0.764892f},
        {0.215571f,	-0.632199f,	-0.744213f},
        {-0.738395f,	0.175626f,	-0.651098f},
        {0.639328f,	-0.081779f,	0.764573f},
        {-0.857643f,	0.494663f,	-0.140558f},
        {0.006709f,	-0.067137f,	0.997721f},
        {0.429332f,	0.565360f,	0.704303f},
        {-0.406916f,	-0.898029f,	0.167223f},
        {0.233182f,	-0.796374f,	0.558045f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_27[][3] =
{
        {0.642059f,	-0.749312f,	0.162148f},
        {-0.733964f,	0.672815f,	-0.092833f},
        {0.406476f,	0.811133f,	0.420524f},
        {-0.075743f,	0.992849f,	-0.092273f},
        {0.208468f,	-0.870477f,	-0.445882f},
        {-0.517860f,	0.102223f,	0.849336f},
        {0.227726f,	-0.460818f,	0.857781f},
        {-0.916701f,	0.197670f,	0.347254f},
        {-0.400145f,	-0.532062f,	0.746186f},
        {0.145772f,	0.163489f,	-0.975716f},
        {0.541421f,	0.177692f,	0.821760f},
        {-0.406599f,	-0.911499f,	-0.062021f},
        {0.963795f,	-0.200266f,	-0.176046f},
        {0.069895f,	-0.940197f,	0.333382f},
        {-0.132009f,	0.701641f,	-0.700195f},
        {0.718361f,	0.230412f,	-0.656405f},
        {0.504263f,	0.778994f,	-0.372675f},
        {-0.643372f,	0.313965f,	-0.698211f},
        {-0.946783f,	-0.086267f,	-0.310095f},
        {0.883299f,	0.455636f,	0.110355f},
        {0.003358f,	0.418172f,	0.908362f},
        {0.572213f,	-0.449517f,	-0.685935f},
        {-0.835283f,	-0.491511f,	0.246414f},
        {-0.567610f,	-0.592648f,	-0.571478f},
        {-0.196169f,	-0.319727f,	-0.926980f},
        {0.851799f,	-0.207903f,	0.480847f},
        {-0.366670f,	0.795515f,	0.482399f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_28[][3] =
{
        {0.544995f,	0.804690f,	0.235487f},
        {-0.284601f,	-0.795159f,	-0.535466f},
        {0.144789f,	0.922527f,	-0.357742f},
        {-0.824814f,	0.420564f,	-0.377900f},
        {0.983432f,	0.003132f,	-0.181253f},
        {0.691354f,	0.609612f,	-0.387818f},
        {-0.430073f,	0.902133f,	-0.034549f},
        {0.376782f,	0.417182f,	0.827039f},
        {-0.803138f,	-0.562404f,	-0.196650f},
        {-0.771902f,	0.504962f,	0.386239f},
        {0.434174f,	-0.821084f,	0.370558f},
        {-0.324074f,	0.606743f,	-0.725837f},
        {-0.676151f,	-0.126067f,	-0.725897f},
        {0.038718f,	-0.997078f,	-0.065845f},
        {-0.078924f,	-0.336863f,	-0.938240f},
        {0.882510f,	0.248757f,	0.399120f},
        {0.648326f,	0.063649f,	-0.758697f},
        {-0.067616f,	-0.647872f,	0.758742f},
        {-0.060125f,	0.864219f,	0.499510f},
        {-0.519971f,	-0.787600f,	0.330631f},
        {0.099701f,	0.275418f,	-0.956141f},
        {0.096903f,	-0.122552f,	0.987720f},
        {0.454365f,	-0.608214f,	-0.650867f},
        {-0.372265f,	0.339937f,	0.863633f},
        {0.788547f,	-0.601137f,	-0.129720f},
        {-0.996586f,	-0.033032f,	0.075668f},
        {0.725452f,	-0.315899f,	0.611497f},
        {-0.699807f,	-0.228562f,	0.676778f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_29[][3] =
{
        {0.766824f,	-0.615677f,	-0.181445f},
        {-0.257730f,	-0.966054f,	0.017735f},
        {0.580576f,	0.805765f,	0.116937f},
        {0.747740f,	0.524282f,	-0.407448f},
        {0.045623f,	0.921968f,	0.384570f},
        {0.838544f,	0.333677f,	0.430701f},
        {-0.734614f,	-0.657945f,	-0.165681f},
        {0.058255f,	-0.096815f,	-0.993596f},
        {-0.477383f,	0.875106f,	0.079346f},
        {0.223934f,	-0.546758f,	0.806790f},
        {0.049555f,	0.923924f,	-0.379352f},
        {0.851118f,	-0.320994f,	0.415404f},
        {-0.524409f,	0.497819f,	0.690775f},
        {0.601153f,	-0.274119f,	-0.750649f},
        {0.365556f,	-0.881254f,	0.299600f},
        {-0.761294f,	0.545360f,	-0.350734f},
        {-0.954718f,	-0.114577f,	-0.274564f},
        {0.442955f,	0.010709f,	0.896480f},
        {-0.306571f,	-0.064019f,	0.949693f},
        {-0.930585f,	0.263338f,	0.254293f},
        {-0.218962f,	-0.652985f,	-0.725028f},
        {-0.338597f,	0.506351f,	-0.793071f},
        {0.974415f,	0.000103f,	-0.224757f},
        {0.161756f,	0.527712f,	0.833879f},
        {-0.371713f,	-0.710556f,	0.597444f},
        {0.243568f,	-0.873983f,	-0.420510f},
        {-0.809003f,	-0.289101f,	0.511796f},
        {-0.592939f,	-0.133208f,	-0.794153f},
        {0.326946f,	0.461931f,	-0.824455f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_30[][3] =
{
        {0.891121f,	0.433454f,	-0.134243f},
        {0.272459f,	-0.444892f,	-0.853134f},
        {-0.507073f,	0.536061f,	-0.674919f},
        {0.966294f,	0.027886f,	0.255927f},
        {-0.274882f,	-0.380106f,	0.883153f},
        {-0.896120f,	-0.399390f,	-0.193537f},
        {-0.594793f,	0.431612f,	0.678183f},
        {-0.462517f,	-0.354923f,	-0.812470f},
        {0.261208f,	-0.675616f,	0.689430f},
        {0.026471f,	-0.968477f,	0.247693f},
        {0.799269f,	-0.556636f,	0.226552f},
        {0.044351f,	-0.882295f,	-0.468603f},
        {-0.590900f,	-0.716604f,	0.370562f},
        {0.847931f,	-0.223899f,	-0.480502f},
        {0.351355f,	0.883468f,	0.309893f},
        {-0.791536f,	-0.163806f,	0.588761f},
        {0.583414f,	-0.175256f,	0.793041f},
        {0.594873f,	0.257165f,	-0.761572f},
        {0.577393f,	-0.778861f,	-0.244934f},
        {0.030092f,	0.147175f,	0.988653f},
        {-0.167612f,	0.981714f,	-0.090248f},
        {-0.664729f,	0.746491f,	0.029778f},
        {-0.027428f,	0.078168f,	-0.996563f},
        {0.606507f,	0.453228f,	0.653249f},
        {0.053397f,	0.684036f,	-0.727491f},
        {-0.849154f,	0.126092f,	-0.512872f},
        {-0.101403f,	0.723238f,	0.683114f},
        {0.473243f,	0.827086f,	-0.303266f},
        {-0.483068f,	-0.833821f,	-0.267186f},
        {-0.968162f,	0.217710f,	0.123550f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_31[][3] =
{
        {0.486824f,	-0.702985f,	0.518474f},
        {0.377321f,	-0.618490f,	-0.689274f},
        {-0.102243f,	0.874372f,	-0.474363f},
        {-0.689179f,	-0.695768f,	0.202334f},
        {-0.074151f,	0.769692f,	0.634095f},
        {-0.711269f,	-0.038470f,	-0.701866f},
        {0.899959f,	-0.376713f,	-0.219456f},
        {-0.017860f,	-0.978186f,	-0.206962f},
        {-0.693352f,	-0.211607f,	0.688829f},
        {0.986754f,	0.159465f,	-0.029783f},
        {0.843591f,	-0.165761f,	0.510761f},
        {0.244143f,	0.328319f,	0.912470f},
        {0.055114f,	0.200966f,	-0.978047f},
        {-0.419229f,	0.274826f,	0.865285f},
        {-0.507938f,	0.522924f,	-0.684507f},
        {0.746732f,	0.599553f,	-0.287972f},
        {-0.140334f,	-0.917190f,	0.372919f},
        {-0.152122f,	-0.317203f,	-0.936077f},
        {-0.971860f,	0.023893f,	0.234345f},
        {-0.202124f,	0.977573f,	0.059137f},
        {-0.870695f,	-0.409019f,	-0.273118f},
        {0.708520f,	0.474975f,	0.521918f},
        {0.383383f,	0.595200f,	-0.706225f},
        {0.426980f,	0.890657f,	0.156263f},
        {-0.876678f,	0.437302f,	-0.200504f},
        {0.310721f,	-0.238932f,	0.919980f},
        {-0.678568f,	0.656025f,	0.330419f},
        {-0.206380f,	-0.510592f,	0.834687f},
        {0.565453f,	-0.822478f,	-0.061588f},
        {0.662639f,	-0.052181f,	-0.747119f},
        {-0.384151f,	-0.730165f,	-0.565055f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_32[][3] =
{
        {0.326293f,	0.941805f,	-0.080848f},
        {0.511855f,	0.173102f,	-0.841451f},
        {0.030715f,	0.844933f,	0.533990f},
        {-0.841463f,	-0.537553f,	0.054569f},
        {-0.014099f,	-0.274476f,	-0.961491f},
        {0.033687f,	-0.313422f,	0.949016f},
        {0.319584f,	-0.844230f,	-0.430282f},
        {0.858839f,	-0.471111f,	-0.201120f},
        {0.832947f,	0.410198f,	-0.371398f},
        {-0.183307f,	0.297759f,	-0.936877f},
        {0.926170f,	-0.238702f,	0.291942f},
        {-0.923297f,	0.033365f,	0.382636f},
        {-0.587791f,	-0.541654f,	0.600926f},
        {-0.622084f,	0.552030f,	0.555225f},
        {-0.681379f,	0.050160f,	-0.730210f},
        {0.042542f,	0.376334f,	0.925507f},
        {-0.729601f,	0.642005f,	-0.235609f},
        {-0.972104f,	0.137240f,	-0.190207f},
        {0.594546f,	0.670974f,	0.443068f},
        {0.630596f,	-0.344667f,	-0.695380f},
        {-0.303024f,	-0.952830f,	-0.017071f},
        {0.416457f,	-0.896133f,	0.153324f},
        {-0.265298f,	0.784830f,	-0.560053f},
        {-0.199061f,	-0.739081f,	-0.643532f},
        {-0.480443f,	0.031408f,	0.876463f},
        {0.941000f,	0.308865f,	0.138278f},
        {-0.061464f,	-0.833424f,	0.549206f},
        {0.321306f,	0.710525f,	-0.626032f},
        {-0.361551f,	0.924809f,	0.118360f},
        {-0.700999f,	-0.505795f,	-0.502764f},
        {0.543071f,	-0.520010f,	0.659290f},
        {0.597357f,	0.122743f,	0.792527f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_33[][3] =
{
        {0.814391f,	-0.346771f,	-0.465314f},
        {0.356001f,	-0.768380f,	-0.531842f},
        {0.631558f,	0.463121f,	-0.621815f},
        {0.347823f,	0.794280f,	0.498134f},
        {-0.407940f,	0.157737f,	-0.899280f},
        {0.021277f,	-0.625271f,	0.780118f},
        {-0.078258f,	-0.048026f,	0.995776f},
        {-0.528333f,	0.758680f,	0.381142f},
        {0.654313f,	-0.755927f,	0.021184f},
        {0.029771f,	0.835079f,	-0.549324f},
        {-0.936070f,	-0.043111f,	-0.349163f},
        {-0.698515f,	0.503786f,	-0.508210f},
        {0.914208f,	-0.296497f,	0.276249f},
        {0.703409f,	0.707819f,	-0.064864f},
        {-0.561250f,	-0.419885f,	0.713229f},
        {-0.932205f,	0.329340f,	0.150095f},
        {0.447654f,	-0.106149f,	-0.887884f},
        {0.141406f,	0.989865f,	0.013123f},
        {-0.455079f,	0.876000f,	-0.159769f},
        {0.410338f,	0.284308f,	0.866482f},
        {-0.161682f,	0.593946f,	0.788091f},
        {-0.034083f,	-0.463682f,	-0.885346f},
        {-0.125385f,	-0.948897f,	-0.289609f},
        {-0.693047f,	-0.683503f,	-0.229149f},
        {-0.571233f,	-0.396204f,	-0.718828f},
        {-0.917581f,	-0.312016f,	0.246354f},
        {0.562931f,	-0.334240f,	0.755905f},
        {0.970323f,	0.147030f,	-0.191979f},
        {0.088559f,	0.400884f,	-0.911838f},
        {0.843164f,	0.302702f,	0.444348f},
        {-0.662693f,	0.186908f,	0.725192f},
        {-0.409217f,	-0.868992f,	0.278200f},
        {0.235445f,	-0.913934f,	0.330591f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_34[][3] =
{
        {0.673353f,	0.654279f,	-0.344261f},
        {0.942470f,	0.171560f,	-0.286911f},
        {0.805713f,	0.525251f,	0.273746f},
        {0.310583f,	0.950529f,	0.005679f},
        {0.599084f,	-0.671797f,	0.435646f},
        {-0.855825f,	-0.503905f,	-0.116802f},
        {0.053991f,	-0.932904f,	0.356055f},
        {0.310256f,	0.266223f,	0.912615f},
        {0.394559f,	-0.027505f,	-0.918459f},
        {-0.440159f,	-0.722078f,	0.533726f},
        {-0.968659f,	0.247889f,	-0.015842f},
        {0.770771f,	0.044114f,	0.635583f},
        {0.312791f,	-0.628454f,	-0.712185f},
        {0.642093f,	-0.755599f,	-0.129560f},
        {-0.236254f,	0.905585f,	0.352279f},
        {-0.706584f,	-0.337157f,	-0.622145f},
        {-0.232449f,	-0.535867f,	-0.811674f},
        {0.330284f,	-0.439762f,	0.835178f},
        {0.960177f,	-0.230959f,	0.157222f},
        {-0.107649f,	0.922747f,	-0.370068f},
        {-0.210014f,	0.059026f,	-0.975915f},
        {-0.276021f,	0.409853f,	0.869387f},
        {0.788496f,	-0.295575f,	-0.539360f},
        {-0.634499f,	-0.139089f,	0.760306f},
        {-0.452294f,	-0.883010f,	-0.125390f},
        {0.346006f,	0.527217f,	-0.776094f},
        {-0.701911f,	0.518064f,	0.488806f},
        {-0.135700f,	-0.247023f,	0.959461f},
        {-0.306982f,	0.576331f,	-0.757367f},
        {-0.920440f,	-0.215104f,	0.326375f},
        {-0.643805f,	0.753944f,	-0.130705f},
        {-0.781948f,	0.240588f,	-0.575043f},
        {0.068185f,	-0.956471f,	-0.283750f},
        {0.302382f,	0.749062f,	0.589467f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_35[][3] =
{
        {0.041982f,	-0.822666f,	0.566972f},
        {0.770989f,	-0.567586f,	-0.288830f},
        {-0.524354f,	0.846124f,	0.095532f},
        {-0.922099f,	0.320527f,	0.216785f},
        {0.573150f,	-0.543599f,	0.613188f},
        {-0.606089f,	-0.789240f,	0.098774f},
        {-0.326952f,	-0.016107f,	-0.944904f},
        {0.195028f,	-0.344947f,	-0.918137f},
        {0.539024f,	0.276075f,	-0.795761f},
        {-0.668065f,	-0.497232f,	0.553579f},
        {-0.658213f,	0.056058f,	0.750742f},
        {-0.119405f,	-0.992832f,	0.005262f},
        {0.182419f,	-0.093785f,	0.978738f},
        {-0.284293f,	-0.634835f,	-0.718444f},
        {0.015530f,	0.441845f,	-0.896957f},
        {-0.083824f,	0.416870f,	0.905093f},
        {0.880920f,	0.346259f,	0.322623f},
        {0.941521f,	-0.271104f,	0.200102f},
        {-0.224061f,	-0.411480f,	0.883448f},
        {0.461543f,	0.743586f,	-0.483795f},
        {-0.409920f,	0.663942f,	-0.625417f},
        {0.945425f,	0.195796f,	-0.260451f},
        {-0.797856f,	-0.037185f,	-0.601700f},
        {0.658801f,	0.053424f,	0.750418f},
        {-0.502836f,	0.613448f,	0.608965f},
        {-0.719648f,	-0.566794f,	-0.401062f},
        {0.390811f,	0.643506f,	0.658155f},
        {-0.974962f,	-0.212229f,	0.066393f},
        {-0.825306f,	0.451849f,	-0.338679f},
        {0.639276f,	0.768368f,	0.030605f},
        {0.489478f,	-0.867170f,	0.091804f},
        {0.702490f,	-0.225418f,	-0.675052f},
        {0.073012f,	0.948874f,	0.307095f},
        {-0.048211f,	0.961164f,	-0.271735f},
        {0.194695f,	-0.853504f,	-0.483347f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_36[][3] =
{
        {0.658899f,	0.096735f,	0.745986f},
        {-0.891234f,	0.452763f,	-0.026612f},
        {-0.505130f,	0.850482f,	0.146710f},
        {0.908101f,	-0.157083f,	0.388173f},
        {-0.453720f,	-0.850532f,	-0.265958f},
        {0.079634f,	-0.850845f,	-0.519347f},
        {-0.332282f,	-0.802571f,	0.495448f},
        {-0.420090f,	0.014424f,	-0.907368f},
        {0.161665f,	0.980654f,	0.110374f},
        {0.944872f,	-0.266302f,	-0.190528f},
        {-0.310817f,	0.289465f,	0.905319f},
        {0.281746f,	0.710898f,	-0.644394f},
        {0.676475f,	-0.647533f,	0.350831f},
        {-0.099927f,	-0.470496f,	-0.876726f},
        {0.642364f,	-0.542650f,	-0.541202f},
        {0.655259f,	0.243467f,	-0.715094f},
        {0.281769f,	-0.613278f,	0.737900f},
        {-0.571976f,	0.580231f,	-0.579806f},
        {-0.891025f,	0.084842f,	-0.445956f},
        {-0.027197f,	-0.988078f,	0.151531f},
        {-0.189785f,	0.908816f,	-0.371531f},
        {0.602853f,	0.774904f,	-0.189981f},
        {0.388628f,	-0.183275f,	-0.902983f},
        {0.769730f,	0.559465f,	0.307432f},
        {-0.022188f,	0.360170f,	-0.932623f},
        {0.180393f,	-0.031800f,	0.983080f},
        {-0.274995f,	-0.337668f,	0.900199f},
        {0.353586f,	0.575929f,	0.737077f},
        {-0.713863f,	-0.402508f,	0.573050f},
        {0.941295f,	0.271692f,	-0.200369f},
        {-0.685718f,	-0.420696f,	-0.593975f},
        {-0.098394f,	0.804029f,	0.586392f},
        {-0.695021f,	0.425495f,	0.579570f},
        {-0.855825f,	-0.516861f,	-0.020460f},
        {0.467216f,	-0.881441f,	-0.069064f},
        {-0.955300f,	-0.020843f,	0.294902f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_37[][3] =
{
        {0.938602f,	-0.012371f,	0.344780f},
        {-0.227443f,	-0.972404f,	-0.051972f},
        {0.127761f,	-0.829685f,	-0.543414f},
        {0.504137f,	-0.543462f,	0.671189f},
        {-0.452309f,	0.866992f,	-0.209146f},
        {0.366960f,	-0.928925f,	0.049393f},
        {-0.996462f,	0.031484f,	-0.077923f},
        {0.956370f,	-0.156465f,	-0.246729f},
        {-0.237429f,	0.547723f,	-0.802264f},
        {-0.253076f,	-0.434361f,	0.864456f},
        {0.033785f,	-0.845465f,	0.532961f},
        {-0.466723f,	0.673304f,	0.573439f},
        {0.558257f,	0.691356f,	-0.458668f},
        {-0.370522f,	0.020410f,	-0.928600f},
        {0.764840f,	0.205416f,	-0.610593f},
        {0.181880f,	-0.117948f,	0.976221f},
        {0.084537f,	0.647973f,	0.756957f},
        {-0.544151f,	-0.749141f,	0.377741f},
        {0.436350f,	0.894717f,	0.095294f},
        {-0.821237f,	0.207519f,	0.531513f},
        {-0.092614f,	0.971441f,	0.218461f},
        {-0.100910f,	-0.429327f,	-0.897494f},
        {-0.751845f,	-0.276563f,	0.598534f},
        {0.652961f,	-0.627526f,	-0.424091f},
        {0.254934f,	0.265850f,	-0.929695f},
        {0.802324f,	-0.565750f,	0.190272f},
        {0.613704f,	0.091507f,	0.784215f},
        {-0.485731f,	-0.712291f,	-0.506663f},
        {0.588213f,	0.588115f,	0.555092f},
        {-0.818703f,	0.568298f,	0.082231f},
        {-0.280439f,	0.208664f,	0.936917f},
        {-0.785977f,	-0.220765f,	-0.577497f},
        {0.058512f,	0.877415f,	-0.476150f},
        {0.888563f,	0.458653f,	0.009671f},
        {-0.848806f,	-0.527534f,	-0.035169f},
        {-0.743239f,	0.406676f,	-0.531235f},
        {0.464929f,	-0.273533f,	-0.842034f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_38[][3] =
{
        {0.969460f,	0.241155f,	-0.044625f},
        {-0.465198f,	0.563573f,	-0.682624f},
        {0.329040f,	-0.798119f,	-0.504716f},
        {0.401701f,	-0.400726f,	0.823441f},
        {-0.263437f,	0.919801f,	-0.290805f},
        {0.731160f,	0.262095f,	0.629850f},
        {0.748008f,	-0.275370f,	-0.603867f},
        {0.939615f,	-0.328818f,	-0.094882f},
        {-0.281977f,	0.024966f,	-0.959096f},
        {0.048805f,	0.549573f,	-0.834019f},
        {-0.210964f,	-0.930396f,	-0.299763f},
        {-0.724969f,	-0.666160f,	-0.175075f},
        {-0.487236f,	-0.356360f,	0.797251f},
        {0.876120f,	-0.188718f,	0.443621f},
        {-0.807486f,	0.448808f,	0.382803f},
        {-0.836788f,	0.221580f,	-0.500688f},
        {-0.993054f,	-0.096450f,	-0.067393f},
        {0.728048f,	0.673778f,	0.126367f},
        {-0.100268f,	-0.731906f,	0.673988f},
        {0.303882f,	0.814627f,	0.494002f},
        {0.027486f,	-0.982716f,	0.183070f},
        {-0.580971f,	-0.748886f,	0.318815f},
        {-0.212126f,	0.602235f,	0.769620f},
        {0.205968f,	-0.419932f,	-0.883875f},
        {-0.890255f,	-0.180333f,	0.418241f},
        {-0.337280f,	0.890107f,	0.306516f},
        {-0.548144f,	0.190350f,	0.814435f},
        {-0.771192f,	0.628338f,	-0.102246f},
        {0.370337f,	0.101806f,	-0.923302f},
        {0.422620f,	0.762874f,	-0.489301f},
        {0.545380f,	-0.717037f,	0.434072f},
        {-0.729333f,	-0.293096f,	-0.618197f},
        {0.763166f,	0.335164f,	-0.552488f},
        {0.294490f,	0.370161f,	0.881054f},
        {0.019244f,	-0.085224f,	0.996176f},
        {0.601586f,	-0.795067f,	-0.077216f},
        {-0.303559f,	-0.581006f,	-0.755171f},
        {0.218119f,	0.975330f,	-0.033979f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_39[][3] =
{
        {0.639125f,	0.617603f,	-0.458351f},
        {-0.266130f,	-0.917830f,	-0.294554f},
        {0.464740f,	-0.783554f,	0.412383f},
        {-0.607878f,	-0.762129f,	0.222809f},
        {0.255505f,	0.466439f,	0.846848f},
        {0.024043f,	0.848258f,	-0.529036f},
        {0.390719f,	0.916461f,	-0.086236f},
        {0.231011f,	-0.969733f,	-0.079065f},
        {-0.983849f,	0.038193f,	-0.174876f},
        {-0.664723f,	0.703842f,	0.250499f},
        {-0.639630f,	-0.040539f,	-0.767613f},
        {0.845708f,	-0.333081f,	-0.416935f},
        {-0.431980f,	0.869546f,	-0.239336f},
        {0.530769f,	0.742583f,	0.408479f},
        {-0.871680f,	-0.315649f,	0.374886f},
        {0.989117f,	-0.082420f,	0.121881f},
        {0.775929f,	-0.630800f,	-0.005023f},
        {0.723218f,	-0.324186f,	0.609803f},
        {0.467256f,	-0.233782f,	-0.852653f},
        {-0.071579f,	-0.507699f,	-0.858556f},
        {-0.164535f,	0.729283f,	0.664135f},
        {0.901416f,	0.432172f,	0.025996f},
        {-0.901517f,	0.206069f,	0.380529f},
        {-0.560713f,	0.335085f,	0.757179f},
        {0.306150f,	-0.097229f,	0.947005f},
        {0.359529f,	-0.749370f,	-0.556044f},
        {-0.145706f,	-0.913911f,	0.378861f},
        {0.089503f,	-0.594462f,	0.799127f},
        {0.207408f,	0.458073f,	-0.864379f},
        {-0.426779f,	0.470331f,	-0.772430f},
        {-0.849108f,	-0.472247f,	-0.236641f},
        {0.753190f,	0.241920f,	0.611703f},
        {-0.072389f,	0.975820f,	0.206242f},
        {-0.226862f,	0.021148f,	0.973697f},
        {-0.038858f,	0.021934f,	-0.999004f},
        {0.781046f,	0.163087f,	-0.602802f},
        {-0.809811f,	0.474478f,	-0.345076f},
        {-0.527901f,	-0.576586f,	-0.623593f},
        {-0.473755f,	-0.427117f,	0.770148f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_40[][3] =
{
        {0.834182f,	0.477660f,	0.275647f},
        {0.443852f,	0.892447f,	-0.080831f},
        {0.532985f,	-0.808681f,	-0.248921f},
        {0.457379f,	0.732006f,	0.504948f},
        {0.029429f,	0.611360f,	0.790805f},
        {-0.572269f,	0.811038f,	0.121347f},
        {0.719704f,	-0.389669f,	-0.574616f},
        {-0.042543f,	0.952530f,	0.301457f},
        {-0.342257f,	-0.938387f,	0.047842f},
        {-0.914946f,	-0.292948f,	0.277588f},
        {-0.061903f,	-0.441288f,	0.895228f},
        {0.592745f,	0.173878f,	0.786397f},
        {-0.585880f,	-0.556059f,	-0.589527f},
        {-0.248299f,	0.664188f,	-0.705125f},
        {0.218666f,	-0.642478f,	-0.734444f},
        {-0.485748f,	0.581399f,	0.652706f},
        {-0.273678f,	-0.321752f,	-0.906408f},
        {0.913710f,	-0.406290f,	0.007911f},
        {-0.915530f,	0.379290f,	0.133955f},
        {0.949996f,	-0.001206f,	0.312261f},
        {-0.465260f,	-0.118217f,	0.877244f},
        {0.503842f,	0.279015f,	-0.817492f},
        {-0.565662f,	-0.653029f,	0.503567f},
        {-0.789354f,	0.125696f,	0.600933f},
        {-0.705344f,	0.583877f,	-0.401968f},
        {-0.717573f,	0.070424f,	-0.692914f},
        {0.262008f,	-0.953565f,	0.148542f},
        {-0.113870f,	-0.898421f,	-0.424114f},
        {0.918212f,	0.051431f,	-0.392736f},
        {0.658066f,	-0.617500f,	0.430863f},
        {-0.209757f,	0.229072f,	-0.950541f},
        {-0.003042f,	-0.824948f,	0.565201f},
        {0.031283f,	0.141276f,	0.989476f},
        {-0.783908f,	-0.605507f,	-0.137295f},
        {-0.969095f,	-0.016888f,	-0.246108f},
        {0.296348f,	0.719710f,	-0.627850f},
        {0.477265f,	-0.338277f,	0.811040f},
        {0.272924f,	-0.137293f,	-0.952189f},
        {0.793702f,	0.528069f,	-0.301961f},
        {-0.140378f,	0.958037f,	-0.249918f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_41[][3] =
{
        {0.776222f,	0.052029f,	0.628309f},
        {0.778680f,	-0.597435f,	-0.191650f},
        {-0.860154f,	-0.508749f,	0.036192f},
        {0.161703f,	0.794852f,	0.584861f},
        {0.549494f,	-0.173216f,	-0.817345f},
        {0.664049f,	0.392440f,	-0.636420f},
        {0.542888f,	-0.410847f,	0.732447f},
        {-0.705216f,	-0.456782f,	0.542236f},
        {0.493666f,	-0.611536f,	-0.618318f},
        {0.933563f,	-0.075633f,	-0.350342f},
        {0.320295f,	0.343881f,	0.882699f},
        {0.239657f,	-0.969620f,	-0.049007f},
        {-0.394848f,	0.632868f,	0.666013f},
        {-0.450756f,	-0.703466f,	-0.549504f},
        {0.003898f,	0.607787f,	-0.794090f},
        {-0.219330f,	0.224037f,	0.949580f},
        {-0.834479f,	-0.357761f,	-0.419109f},
        {-0.734452f,	0.667425f,	-0.122979f},
        {0.705158f,	0.530754f,	0.470162f},
        {0.325172f,	0.840191f,	-0.433984f},
        {-0.113611f,	-0.398962f,	-0.909902f},
        {-0.253886f,	-0.477260f,	0.841288f},
        {0.681660f,	-0.672748f,	0.287663f},
        {0.577942f,	0.813619f,	0.063304f},
        {0.059881f,	0.997776f,	0.029292f},
        {0.140674f,	-0.196357f,	0.970389f},
        {-0.674668f,	0.063596f,	0.735376f},
        {0.975924f,	-0.111168f,	0.187656f},
        {-0.392888f,	-0.917550f,	-0.061167f},
        {-0.986229f,	-0.021178f,	0.164026f},
        {0.223984f,	0.168034f,	-0.959998f},
        {-0.328283f,	0.813384f,	-0.480248f},
        {-0.714356f,	-0.023852f,	-0.699375f},
        {-0.857146f,	0.419934f,	0.298255f},
        {-0.393334f,	0.894674f,	0.211772f},
        {0.055853f,	-0.837535f,	-0.543522f},
        {-0.305412f,	-0.856165f,	0.416780f},
        {0.201316f,	-0.830756f,	0.518957f},
        {-0.772915f,	0.390495f,	-0.500116f},
        {-0.308747f,	0.123988f,	-0.943028f},
        {0.889036f,	0.436812f,	-0.137150f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_42[][3] =
{
        {0.839198f,	-0.117501f,	0.530981f},
        {-0.918620f,	0.276255f,	-0.282524f},
        {-0.520356f,	-0.401337f,	-0.753763f},
        {-0.220628f,	0.092189f,	-0.970991f},
        {-0.672912f,	-0.701968f,	-0.233303f},
        {-0.556887f,	0.818468f,	-0.141376f},
        {0.172776f,	0.948642f,	-0.265005f},
        {0.429060f,	-0.415081f,	0.802256f},
        {0.674214f,	-0.651182f,	0.348422f},
        {-0.195458f,	-0.115480f,	0.973889f},
        {0.349872f,	0.696265f,	0.626741f},
        {0.041028f,	-0.364165f,	-0.930430f},
        {-0.237064f,	0.797276f,	-0.555114f},
        {-0.241698f,	-0.790844f,	-0.562270f},
        {0.562088f,	-0.460678f,	-0.686901f},
        {-0.818409f,	-0.095787f,	-0.566596f},
        {0.526553f,	0.644718f,	-0.554148f},
        {0.157624f,	-0.875771f,	0.456267f},
        {0.275281f,	-0.811301f,	-0.515762f},
        {-0.901983f,	-0.426796f,	0.065357f},
        {0.478715f,	-0.875301f,	-0.068405f},
        {-0.684298f,	0.053376f,	0.727246f},
        {-0.121263f,	-0.991138f,	-0.054233f},
        {0.867338f,	-0.160836f,	-0.471017f},
        {0.603300f,	0.796671f,	0.036674f},
        {0.971498f,	0.214937f,	0.099972f},
        {0.741985f,	0.471033f,	0.477061f},
        {0.120674f,	0.500565f,	-0.857247f},
        {-0.571827f,	0.557212f,	0.602104f},
        {-0.102439f,	-0.572456f,	0.813511f},
        {-0.822692f,	0.539824f,	0.178233f},
        {-0.651010f,	-0.458536f,	0.604923f},
        {0.858641f,	0.340049f,	-0.383539f},
        {0.921052f,	-0.388559f,	-0.026189f},
        {-0.063484f,	0.985273f,	0.158767f},
        {0.454963f,	0.073170f,	-0.887499f},
        {-0.067579f,	0.356490f,	0.931852f},
        {-0.973817f,	0.016207f,	0.226754f},
        {-0.146824f,	0.796496f,	0.586546f},
        {-0.428107f,	-0.838696f,	0.336620f},
        {-0.562582f,	0.421626f,	-0.711149f},
        {0.434082f,	0.116671f,	0.893287f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_43[][3] =
{
        {0.962560f,	0.256194f,	-0.088563f},
        {0.926980f,	-0.374346f,	0.023959f},
        {-0.058992f,	-0.997047f,	-0.049162f},
        {-0.587858f,	-0.095722f,	-0.803281f},
        {-0.621859f,	-0.780740f,	-0.061119f},
        {-0.420092f,	0.315003f,	0.851056f},
        {-0.420493f,	-0.722135f,	-0.549278f},
        {0.718804f,	0.607796f,	-0.337497f},
        {0.654755f,	0.657128f,	0.373468f},
        {-0.131952f,	0.455366f,	-0.880472f},
        {0.425022f,	0.905117f,	-0.010902f},
        {-0.739069f,	0.526270f,	0.420495f},
        {0.076379f,	0.903324f,	-0.422104f},
        {0.095244f,	0.309821f,	0.946012f},
        {0.405018f,	-0.789053f,	0.461905f},
        {0.655180f,	0.174851f,	-0.734960f},
        {-0.142903f,	-0.197233f,	0.969886f},
        {0.428030f,	-0.266479f,	0.863585f},
        {-0.946049f,	-0.320558f,	0.047253f},
        {0.568033f,	-0.822982f,	-0.006155f},
        {-0.958936f,	0.217230f,	-0.182354f},
        {0.877451f,	-0.184378f,	-0.442815f},
        {-0.013500f,	-0.633919f,	0.773281f},
        {0.165570f,	-0.874924f,	-0.455076f},
        {-0.123982f,	-0.027774f,	-0.991896f},
        {-0.645106f,	-0.603638f,	0.468464f},
        {-0.301520f,	0.773105f,	0.558027f},
        {-0.820997f,	-0.344165f,	-0.455537f},
        {-0.416833f,	0.774014f,	-0.476606f},
        {0.901843f,	0.161190f,	0.400870f},
        {-0.202806f,	-0.896019f,	0.394993f},
        {0.188321f,	0.799802f,	0.569958f},
        {0.782036f,	-0.364417f,	0.505589f},
        {0.371651f,	-0.199816f,	-0.906614f},
        {0.589781f,	-0.606491f,	-0.533224f},
        {-0.699198f,	0.369828f,	-0.611841f},
        {-0.040742f,	-0.542996f,	-0.838747f},
        {-0.154931f,	0.984947f,	0.076652f},
        {0.554417f,	0.280324f,	0.783607f},
        {-0.922152f,	0.067671f,	0.380863f},
        {-0.687856f,	0.724855f,	-0.037936f},
        {0.342816f,	0.572756f,	-0.744599f},
        {-0.632065f,	-0.191761f,	0.750814f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_44[][3] =
{
        {0.962800f,	-0.244780f,	0.114455f},
        {-0.832163f,	0.345581f,	-0.433679f},
        {-0.375529f,	-0.695337f,	0.612768f},
        {0.359776f,	-0.409857f,	-0.838200f},
        {-0.099806f,	0.871019f,	0.481003f},
        {0.601490f,	0.094547f,	-0.793266f},
        {-0.538734f,	0.672320f,	0.507691f},
        {-0.396984f,	0.916892f,	-0.041386f},
        {0.022546f,	0.940957f,	-0.337775f},
        {-0.786891f,	0.616374f,	-0.029764f},
        {0.183810f,	-0.978867f,	-0.089631f},
        {-0.998617f,	-0.022793f,	-0.047386f},
        {0.199090f,	0.607858f,	0.768682f},
        {0.116889f,	0.333003f,	-0.935653f},
        {-0.894903f,	0.246522f,	0.371987f},
        {0.803439f,	-0.108516f,	0.585415f},
        {-0.694132f,	-0.686554f,	0.216390f},
        {-0.001965f,	-0.812886f,	-0.582419f},
        {0.281760f,	-0.049958f,	0.958184f},
        {-0.573474f,	0.217482f,	0.789828f},
        {0.074618f,	-0.700478f,	0.709762f},
        {0.339113f,	0.656134f,	-0.674159f},
        {-0.864737f,	-0.450274f,	-0.222449f},
        {-0.112845f,	0.251150f,	0.961348f},
        {-0.050938f,	-0.114687f,	-0.992095f},
        {0.610255f,	0.750410f,	-0.253916f},
        {0.501241f,	-0.459503f,	0.733222f},
        {0.678745f,	0.677623f,	0.283075f},
        {0.866651f,	0.308193f,	-0.392343f},
        {-0.814429f,	-0.269893f,	0.513676f},
        {0.851197f,	-0.255415f,	-0.458505f},
        {-0.262774f,	-0.960942f,	0.086837f},
        {-0.322205f,	-0.267935f,	0.907962f},
        {-0.341536f,	0.709891f,	-0.615961f},
        {-0.507121f,	-0.766125f,	-0.394819f},
        {-0.459068f,	0.287011f,	-0.840763f},
        {0.256825f,	0.955169f,	0.147286f},
        {-0.342306f,	-0.463554f,	-0.817278f},
        {0.959811f,	0.257539f,	0.111522f},
        {0.530276f,	-0.718485f,	-0.450096f},
        {0.754890f,	-0.655554f,	0.019736f},
        {0.633354f,	0.362566f,	0.683673f},
        {-0.730498f,	-0.142963f,	-0.667783f},
        {0.413081f,	-0.842887f,	0.344826f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_45[][3] =
{
        {0.830550f,	0.260347f,	0.492348f},
        {-0.878392f,	-0.477896f,	0.006522f},
        {0.483961f,	-0.747863f,	-0.454404f},
        {0.252755f,	-0.966354f,	-0.047691f},
        {0.123558f,	-0.664097f,	0.737366f},
        {0.787796f,	-0.615907f,	-0.005992f},
        {-0.808073f,	-0.255721f,	0.530684f},
        {0.117776f,	-0.219672f,	0.968438f},
        {0.582041f,	-0.350979f,	-0.733514f},
        {-0.581040f,	-0.728175f,	0.363530f},
        {0.513890f,	-0.765496f,	0.387212f},
        {0.388066f,	0.563397f,	-0.729376f},
        {0.647126f,	0.677622f,	0.349366f},
        {-0.256042f,	0.921948f,	0.290609f},
        {-0.646999f,	0.439347f,	-0.623190f},
        {-0.578903f,	-0.027059f,	-0.814948f},
        {0.942615f,	0.324278f,	-0.079500f},
        {-0.626079f,	-0.668702f,	-0.401078f},
        {-0.219958f,	0.701457f,	-0.677920f},
        {-0.761717f,	0.253219f,	0.596379f},
        {0.165497f,	0.775547f,	0.609211f},
        {0.138975f,	0.399476f,	0.906149f},
        {-0.716510f,	0.666051f,	0.207338f},
        {-0.334939f,	0.082511f,	0.938620f},
        {-0.102756f,	-0.920275f,	0.377538f},
        {-0.902942f,	-0.137733f,	-0.407094f},
        {-0.384137f,	-0.464657f,	-0.797830f},
        {0.336128f,	0.092857f,	-0.937228f},
        {-0.989090f,	0.077261f,	0.125427f},
        {0.654451f,	0.716516f,	-0.241450f},
        {-0.383169f,	0.899965f,	-0.207954f},
        {-0.312498f,	-0.943514f,	-0.110121f},
        {0.079296f,	-0.365509f,	-0.927424f},
        {-0.385508f,	0.583366f,	0.714890f},
        {-0.395754f,	-0.436504f,	0.807987f},
        {0.917328f,	-0.227664f,	-0.326616f},
        {0.961752f,	-0.156740f,	0.224646f},
        {0.522104f,	0.114408f,	0.845173f},
        {-0.028611f,	-0.820660f,	-0.570701f},
        {0.779972f,	0.206940f,	-0.590610f},
        {-0.143439f,	0.253425f,	-0.956661f},
        {0.158210f,	0.905346f,	-0.394105f},
        {-0.871798f,	0.441384f,	-0.212480f},
        {0.662934f,	-0.354499f,	0.659431f},
        {0.261575f,	0.959006f,	0.109022f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_46[][3] =
{
        {0.880930f,	0.318379f,	0.350138f},
        {0.035725f,	0.910309f,	-0.412384f},
        {0.977453f,	-0.141336f,	0.156878f},
        {-0.568599f,	-0.554904f,	-0.607270f},
        {0.379619f,	0.531469f,	-0.757252f},
        {-0.240499f,	-0.175437f,	0.954663f},
        {0.645840f,	0.662210f,	-0.379959f},
        {-0.969496f,	0.231914f,	0.079328f},
        {-0.379358f,	0.306186f,	0.873120f},
        {0.585895f,	-0.435760f,	-0.683257f},
        {0.668508f,	-0.136416f,	0.731087f},
        {0.576727f,	0.680197f,	0.452458f},
        {0.605870f,	0.118744f,	-0.786652f},
        {-0.257828f,	0.963626f,	0.070359f},
        {-0.103760f,	-0.601994f,	-0.791730f},
        {-0.752014f,	-0.166313f,	0.637821f},
        {-0.215900f,	-0.907583f,	-0.360111f},
        {-0.852450f,	0.375838f,	-0.363422f},
        {0.322740f,	-0.825439f,	-0.463129f},
        {0.213220f,	-0.251054f,	-0.944198f},
        {-0.133198f,	0.044045f,	-0.990110f},
        {-0.752124f,	-0.647409f,	-0.123170f},
        {0.918476f,	0.363671f,	-0.155386f},
        {-0.685076f,	0.693988f,	0.221477f},
        {0.207182f,	-0.283765f,	0.936244f},
        {0.091195f,	0.413480f,	0.905935f},
        {-0.065048f,	0.542812f,	-0.837332f},
        {-0.501771f,	0.799243f,	-0.330811f},
        {0.805776f,	-0.559376f,	-0.194480f},
        {-0.520114f,	0.452044f,	-0.724663f},
        {-0.109968f,	-0.786567f,	0.607634f},
        {-0.763830f,	0.322925f,	0.558823f},
        {-0.911221f,	-0.168247f,	-0.375991f},
        {-0.939568f,	-0.291176f,	0.180078f},
        {0.506873f,	0.297199f,	0.809168f},
        {-0.592003f,	-0.075685f,	-0.802374f},
        {0.501979f,	-0.861720f,	0.073863f},
        {0.035355f,	-0.996220f,	0.079342f},
        {-0.520784f,	-0.564112f,	0.640750f},
        {0.752003f,	-0.512572f,	0.414441f},
        {0.910870f,	-0.078769f,	-0.405106f},
        {0.433658f,	0.900281f,	-0.037890f},
        {-0.244290f,	0.752313f,	0.611840f},
        {-0.471603f,	-0.861961f,	0.186046f},
        {0.155695f,	0.912752f,	0.377680f},
        {0.338914f,	-0.709807f,	0.617504f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_47[][3] =
{
        {0.690401f,	-0.294778f,	0.660646f},
        {0.028592f,	-0.782339f,	-0.622196f},
        {-0.877513f,	-0.437835f,	-0.195631f},
        {-0.766518f,	0.559635f,	-0.315054f},
        {0.989985f,	0.016232f,	-0.140234f},
        {0.834440f,	-0.337002f,	-0.436051f},
        {0.847034f,	0.525993f,	0.076582f},
        {0.405067f,	0.737173f,	0.540829f},
        {-0.689614f,	0.225172f,	-0.688280f},
        {-0.686952f,	-0.041436f,	0.725521f},
        {0.535823f,	0.305145f,	0.787261f},
        {0.175725f,	0.095577f,	-0.979789f},
        {0.937074f,	-0.271368f,	0.219662f},
        {-0.283916f,	-0.914757f,	0.287421f},
        {-0.046517f,	0.551698f,	-0.832746f},
        {-0.192874f,	-0.411407f,	-0.890811f},
        {-0.636222f,	-0.771013f,	0.027568f},
        {-0.169071f,	-0.643145f,	0.746847f},
        {-0.629406f,	-0.536303f,	0.562341f},
        {-0.971056f,	0.048172f,	-0.233944f},
        {0.557519f,	-0.110964f,	-0.822715f},
        {0.829475f,	0.346282f,	-0.438245f},
        {-0.313372f,	0.067122f,	-0.947255f},
        {-0.685723f,	-0.310894f,	-0.658125f},
        {0.406809f,	-0.550917f,	-0.728695f},
        {0.689714f,	-0.694163f,	0.205992f},
        {-0.931448f,	-0.208247f,	0.298392f},
        {0.289560f,	-0.142910f,	0.946431f},
        {-0.239537f,	0.795665f,	0.556363f},
        {-0.103340f,	0.969928f,	-0.220366f},
        {0.582075f,	-0.771291f,	-0.257486f},
        {0.528239f,	0.849079f,	0.005277f},
        {0.322763f,	-0.652015f,	0.686076f},
        {0.064544f,	0.970122f,	0.233876f},
        {0.860225f,	0.228618f,	0.455793f},
        {-0.681482f,	0.522370f,	0.512554f},
        {0.079532f,	0.429409f,	0.899602f},
        {-0.927865f,	0.327485f,	0.178383f},
        {0.043160f,	-0.983385f,	-0.176327f},
        {0.336380f,	0.826084f,	-0.452143f},
        {-0.440122f,	-0.774478f,	-0.454397f},
        {0.502115f,	0.463080f,	-0.730368f},
        {-0.198894f,	-0.181984f,	0.962976f},
        {-0.551694f,	0.831569f,	0.064243f},
        {0.228136f,	-0.934147f,	0.274451f},
        {-0.372452f,	0.325739f,	0.869007f},
        {-0.368799f,	0.739430f,	-0.563232f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_48[][3] =
{
        {0.937324f,	-0.301406f,	0.174867f},
        {0.487592f,	0.763020f,	0.424328f},
        {-0.524864f,	-0.801792f,	0.285740f},
        {0.514509f,	0.682185f,	-0.519523f},
        {0.881079f,	0.121636f,	0.457062f},
        {0.357006f,	-0.827575f,	0.433206f},
        {0.331168f,	-0.943472f,	-0.013738f},
        {-0.176528f,	-0.254279f,	0.950884f},
        {-0.674463f,	-0.714441f,	-0.186206f},
        {-0.415972f,	0.298793f,	0.858889f},
        {0.952188f,	-0.150442f,	-0.265903f},
        {-0.557396f,	0.401496f,	-0.726712f},
        {-0.862355f,	0.112750f,	0.493591f},
        {0.731222f,	-0.679193f,	-0.063341f},
        {0.577279f,	0.358636f,	0.733573f},
        {0.451052f,	-0.136258f,	0.882035f},
        {0.209489f,	-0.084969f,	-0.974112f},
        {0.181883f,	-0.593275f,	0.784183f},
        {0.683934f,	-0.128874f,	-0.718071f},
        {0.853260f,	0.304529f,	-0.423331f},
        {-0.454469f,	0.792142f,	-0.407392f},
        {0.061162f,	0.180152f,	0.981735f},
        {0.078474f,	-0.898683f,	-0.431521f},
        {0.596937f,	-0.602844f,	-0.529383f},
        {-0.184719f,	0.840230f,	0.509797f},
        {-0.629603f,	0.577412f,	0.519803f},
        {-0.310206f,	-0.420432f,	-0.852648f},
        {0.052570f,	0.879229f,	-0.473490f},
        {0.407107f,	0.341297f,	-0.847219f},
        {-0.626271f,	-0.236388f,	0.742903f},
        {-0.988727f,	0.144655f,	0.038645f},
        {0.169732f,	0.984526f,	0.043588f},
        {0.119526f,	0.625430f,	0.771071f},
        {0.624671f,	0.779004f,	-0.054207f},
        {-0.862288f,	0.325671f,	-0.387811f},
        {0.190098f,	-0.557947f,	-0.807810f},
        {-0.737988f,	-0.190057f,	-0.647496f},
        {-0.066351f,	0.531245f,	-0.844616f},
        {0.912782f,	0.399145f,	0.086677f},
        {-0.385908f,	-0.758148f,	-0.525630f},
        {-0.858931f,	-0.416394f,	0.298083f},
        {-0.319243f,	0.946381f,	0.049462f},
        {-0.149394f,	-0.985592f,	0.079310f},
        {-0.932508f,	-0.286733f,	-0.219572f},
        {-0.300478f,	0.051903f,	-0.952375f},
        {-0.757997f,	0.650613f,	0.046301f},
        {-0.288253f,	-0.696794f,	0.656802f},
        {0.702873f,	-0.426098f,	0.569571f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_49[][3] =
{
        {0.715019f,	-0.673002f,	0.189251f},
        {0.894247f,	-0.411644f,	-0.175704f},
        {0.289752f,	-0.450996f,	-0.844184f},
        {0.241352f,	0.016482f,	-0.970298f},
        {-0.444797f,	-0.284814f,	0.849139f},
        {-0.888644f,	-0.385433f,	-0.248503f},
        {-0.204429f,	0.244236f,	0.947923f},
        {-0.356978f,	0.019744f,	-0.933904f},
        {0.872485f,	-0.243983f,	0.423370f},
        {-0.962602f,	0.245634f,	0.114283f},
        {-0.845732f,	0.460906f,	-0.268891f},
        {-0.802634f,	0.101235f,	0.587818f},
        {-0.852971f,	0.037823f,	-0.520587f},
        {0.928113f,	0.108382f,	-0.356173f},
        {0.303538f,	-0.879017f,	0.367688f},
        {0.707133f,	-0.250426f,	-0.661249f},
        {-0.007287f,	-0.854031f,	-0.520170f},
        {0.470803f,	0.671945f,	-0.571694f},
        {-0.138430f,	0.971378f,	0.193032f},
        {-0.263209f,	-0.816091f,	0.514506f},
        {0.493618f,	0.809206f,	0.318632f},
        {-0.221593f,	0.771903f,	0.595871f},
        {-0.549772f,	0.457468f,	-0.698909f},
        {0.285527f,	0.281003f,	0.916249f},
        {0.781734f,	0.430072f,	0.451586f},
        {0.281994f,	-0.952325f,	-0.116430f},
        {0.625211f,	0.272660f,	-0.731278f},
        {-0.953815f,	-0.229506f,	0.193813f},
        {-0.670266f,	0.699479f,	0.247936f},
        {-0.610592f,	-0.359624f,	-0.705584f},
        {-0.004661f,	0.392397f,	-0.919784f},
        {-0.502863f,	-0.771689f,	-0.389391f},
        {-0.514052f,	0.822280f,	-0.244144f},
        {-0.656025f,	-0.747672f,	0.103046f},
        {-0.024685f,	0.963120f,	-0.267939f},
        {0.638579f,	0.050206f,	0.767917f},
        {0.818213f,	0.560930f,	-0.126035f},
        {0.028215f,	-0.196607f,	0.980076f},
        {-0.174738f,	-0.498991f,	-0.848808f},
        {-0.547490f,	0.440540f,	0.711463f},
        {0.419761f,	0.900095f,	-0.116748f},
        {0.244444f,	0.691953f,	0.679299f},
        {0.520510f,	-0.451594f,	0.724660f},
        {0.548482f,	-0.712376f,	-0.437823f},
        {-0.082265f,	0.742869f,	-0.664363f},
        {0.987770f,	0.096441f,	0.122516f},
        {-0.199391f,	-0.979331f,	0.033957f},
        {-0.696520f,	-0.482793f,	0.530821f},
        {0.079945f,	-0.628442f,	0.773737f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_50[][3] =
{
        {0.503173f,	-0.855392f,	-0.122971f},
        {-0.643073f,	0.547888f,	-0.535047f},
        {-0.106334f,	-0.531930f,	0.840085f},
        {-0.575611f,	-0.604238f,	-0.550970f},
        {0.044903f,	0.815769f,	-0.576632f},
        {0.328803f,	-0.880592f,	0.341242f},
        {-0.895138f,	-0.354036f,	-0.270899f},
        {0.608431f,	0.082945f,	-0.789261f},
        {0.179318f,	-0.266462f,	-0.947018f},
        {0.191834f,	0.531956f,	0.824756f},
        {-0.490894f,	-0.860684f,	-0.135080f},
        {-0.852662f,	-0.000467f,	-0.522462f},
        {-0.511303f,	-0.742327f,	0.433037f},
        {0.972882f,	0.128542f,	-0.192293f},
        {0.933352f,	-0.140313f,	0.330404f},
        {0.349103f,	-0.552988f,	0.756525f},
        {-0.240326f,	0.535450f,	-0.809652f},
        {-0.825211f,	-0.547559f,	0.138584f},
        {-0.635565f,	0.645229f,	0.423953f},
        {-0.348101f,	-0.283666f,	-0.893509f},
        {0.644783f,	-0.155126f,	0.748459f},
        {-0.606137f,	-0.363420f,	0.707477f},
        {0.378002f,	0.808780f,	0.450543f},
        {-0.048029f,	-0.989895f,	-0.133419f},
        {-0.658072f,	0.105265f,	0.745560f},
        {-0.507058f,	0.120959f,	-0.853382f},
        {-0.127049f,	-0.686293f,	-0.716143f},
        {0.090386f,	0.199870f,	-0.975645f},
        {0.855371f,	-0.504605f,	-0.117103f},
        {0.244588f,	-0.822214f,	-0.513946f},
        {0.661511f,	0.383917f,	0.644214f},
        {-0.948440f,	-0.127071f,	0.290368f},
        {0.690200f,	0.719508f,	0.077021f},
        {-0.623282f,	0.778641f,	-0.072376f},
        {0.357311f,	0.912663f,	-0.198434f},
        {0.914825f,	0.326788f,	0.237286f},
        {0.856659f,	-0.203387f,	-0.474098f},
        {-0.230602f,	0.795300f,	0.560643f},
        {-0.169723f,	-0.078970f,	0.982323f},
        {-0.903541f,	0.314109f,	0.291460f},
        {-0.929380f,	0.326429f,	-0.172327f},
        {0.413063f,	0.542123f,	-0.731766f},
        {0.285972f,	0.056286f,	0.956583f},
        {-0.294545f,	0.402002f,	0.866970f},
        {-0.231239f,	0.947575f,	-0.220523f},
        {-0.015750f,	0.979727f,	0.199717f},
        {0.540282f,	-0.488676f,	-0.685048f},
        {-0.110034f,	-0.907568f,	0.405232f},
        {0.752473f,	0.520821f,	-0.403150f},
        {0.729876f,	-0.580662f,	0.360711f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_51[][3] =
{
        {0.814974f,	-0.136994f,	0.563072f},
        {-0.804428f,	0.288896f,	-0.519072f},
        {0.456743f,	-0.298022f,	0.838194f},
        {0.953271f,	0.252281f,	-0.166219f},
        {0.010644f,	-0.873855f,	-0.486070f},
        {0.313223f,	-0.944813f,	0.096025f},
        {-0.181606f,	0.833617f,	-0.521634f},
        {0.906825f,	-0.351607f,	-0.232465f},
        {0.353809f,	0.912512f,	-0.205282f},
        {-0.027765f,	0.350882f,	-0.936008f},
        {-0.522538f,	-0.535403f,	0.663549f},
        {0.472818f,	-0.704039f,	0.529879f},
        {-0.861591f,	-0.345200f,	-0.372153f},
        {-0.089885f,	0.794760f,	0.600231f},
        {-0.445463f,	0.457884f,	-0.769354f},
        {-0.987862f,	0.055976f,	-0.144897f},
        {0.802350f,	0.472727f,	0.364367f},
        {-0.860721f,	0.508692f,	0.019788f},
        {-0.184924f,	-0.104429f,	-0.977189f},
        {0.431908f,	0.824765f,	0.364989f},
        {0.037002f,	-0.591560f,	0.805412f},
        {0.768755f,	0.311518f,	-0.558545f},
        {0.594267f,	0.254261f,	0.763019f},
        {0.022355f,	0.997744f,	0.063301f},
        {0.742509f,	-0.204236f,	-0.637941f},
        {-0.223584f,	-0.206733f,	0.952508f},
        {0.346335f,	-0.144440f,	-0.926925f},
        {-0.475560f,	-0.582823f,	-0.658908f},
        {-0.856666f,	-0.489331f,	0.163338f},
        {-0.785243f,	0.314038f,	0.533642f},
        {-0.641718f,	-0.068112f,	0.763910f},
        {0.985564f,	-0.031274f,	0.166389f},
        {-0.555557f,	0.673438f,	0.487686f},
        {0.273146f,	0.739144f,	-0.615677f},
        {-0.943777f,	-0.077760f,	0.321308f},
        {-0.513584f,	-0.811907f,	0.277559f},
        {-0.594590f,	-0.769598f,	-0.232768f},
        {-0.155336f,	-0.984203f,	-0.084944f},
        {0.796531f,	-0.564761f,	0.215831f},
        {-0.582754f,	0.757272f,	-0.294851f},
        {0.725628f,	0.678949f,	-0.111766f},
        {-0.059226f,	-0.893474f,	0.445193f},
        {0.431069f,	0.352107f,	-0.830783f},
        {0.145583f,	0.078329f,	0.986240f},
        {-0.284650f,	0.363904f,	0.886876f},
        {-0.619777f,	-0.098095f,	-0.778623f},
        {0.258226f,	0.568118f,	0.781384f},
        {-0.017568f,	-0.537012f,	-0.843392f},
        {0.586506f,	-0.776827f,	-0.229240f},
        {0.443480f,	-0.624682f,	-0.642727f},
        {-0.397149f,	0.909374f,	0.123743f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_52[][3] =
{
        {-0.642119f,	-0.477846f,	0.599455f},
        {-0.505774f,	0.854122f,	-0.121111f},
        {0.999599f,	-0.010243f,	0.026414f},
        {0.536880f,	-0.824293f,	-0.179725f},
        {0.766547f,	0.484196f,	0.421853f},
        {-0.649009f,	-0.702112f,	-0.292962f},
        {-0.736519f,	0.060861f,	0.673674f},
        {0.084413f,	-0.988153f,	-0.128173f},
        {0.111807f,	-0.934085f,	0.339093f},
        {-0.691994f,	-0.704661f,	0.156838f},
        {-0.934454f,	-0.218295f,	0.281323f},
        {0.104881f,	0.987787f,	0.115226f},
        {-0.205343f,	-0.518455f,	-0.830084f},
        {-0.007342f,	0.714749f,	0.699343f},
        {-0.271161f,	-0.889497f,	-0.367786f},
        {-0.371335f,	-0.102947f,	0.922774f},
        {0.540747f,	-0.763119f,	0.353896f},
        {0.259792f,	-0.602623f,	0.754555f},
        {-0.931546f,	-0.302604f,	-0.201626f},
        {-0.153832f,	0.914308f,	-0.374668f},
        {0.282966f,	0.808488f,	-0.516020f},
        {0.190903f,	0.122349f,	-0.973954f},
        {-0.319507f,	-0.885132f,	0.338315f},
        {-0.615766f,	-0.405685f,	-0.675464f},
        {0.857191f,	-0.514883f,	-0.010951f},
        {0.881191f,	0.058706f,	0.469101f},
        {-0.269673f,	-0.005554f,	-0.962936f},
        {-0.507837f,	0.494608f,	0.705312f},
        {0.414280f,	0.785907f,	0.459045f},
        {0.547973f,	-0.085405f,	0.832125f},
        {0.605005f,	-0.515778f,	-0.606583f},
        {-0.097388f,	0.588103f,	-0.802901f},
        {0.439137f,	0.478543f,	-0.760365f},
        {0.251020f,	-0.335527f,	-0.907971f},
        {-0.212301f,	-0.583439f,	0.783918f},
        {0.761790f,	-0.397606f,	0.511454f},
        {-0.710788f,	0.650005f,	0.268837f},
        {-0.491119f,	0.415259f,	-0.765742f},
        {0.894536f,	-0.199825f,	-0.399845f},
        {-0.751658f,	0.025532f,	-0.659059f},
        {-0.955870f,	0.186032f,	-0.227387f},
        {0.176717f,	-0.771598f,	-0.611071f},
        {0.820985f,	0.570496f,	-0.022754f},
        {-0.285557f,	0.893809f,	0.345778f},
        {-0.091009f,	0.309140f,	0.946652f},
        {-0.725204f,	0.569996f,	-0.386243f},
        {-0.932923f,	0.272366f,	0.235525f},
        {0.846277f,	0.357982f,	-0.394543f},
        {0.414745f,	0.382778f,	0.825510f},
        {0.119592f,	-0.159392f,	0.979945f},
        {0.669359f,	0.049139f,	-0.741312f},
        {0.488693f,	0.863495f,	-0.124722f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_53[][3] =
{
        {-0.912879f,	-0.407861f,	0.017342f},
        {-0.935598f,	-0.099050f,	-0.338887f},
        {-0.727080f,	-0.479811f,	0.491056f},
        {-0.030710f,	0.974693f,	-0.221426f},
        {0.664809f,	0.699220f,	0.262907f},
        {-0.721854f,	0.639108f,	0.265458f},
        {0.915015f,	0.401800f,	0.036118f},
        {0.202121f,	0.959328f,	0.197069f},
        {0.486458f,	0.029475f,	0.873207f},
        {-0.445035f,	0.387065f,	0.807542f},
        {-0.544102f,	-0.499956f,	-0.673793f},
        {-0.106285f,	-0.615891f,	-0.780629f},
        {-0.176645f,	-0.151837f,	0.972493f},
        {0.618707f,	-0.779268f,	-0.099712f},
        {0.001184f,	-0.781792f,	0.623538f},
        {0.520905f,	-0.731994f,	0.439140f},
        {-0.978844f,	0.025704f,	0.202987f},
        {0.697724f,	-0.318266f,	0.641785f},
        {0.667734f,	0.375899f,	0.642519f},
        {0.503544f,	-0.616383f,	-0.605405f},
        {0.246946f,	-0.339022f,	-0.907789f},
        {-0.240751f,	0.870842f,	0.428572f},
        {0.085429f,	0.195562f,	0.976963f},
        {0.883623f,	-0.392575f,	-0.255138f},
        {0.311451f,	0.715372f,	0.625493f},
        {-0.584269f,	-0.788415f,	0.192436f},
        {0.115168f,	0.112128f,	-0.986997f},
        {0.721916f,	-0.176473f,	-0.669100f},
        {-0.260836f,	0.766949f,	-0.586306f},
        {-0.664914f,	0.650475f,	-0.367114f},
        {0.511376f,	0.838991f,	-0.185979f},
        {-0.287658f,	-0.089213f,	-0.953569f},
        {0.960809f,	0.070118f,	-0.268197f},
        {0.232669f,	-0.964361f,	0.125991f},
        {0.539492f,	0.219756f,	-0.812807f},
        {-0.792750f,	0.309113f,	0.525354f},
        {-0.351467f,	-0.517887f,	0.779913f},
        {-0.069174f,	0.597026f,	0.799234f},
        {-0.003760f,	0.513766f,	-0.857922f},
        {0.322833f,	0.732317f,	-0.599575f},
        {-0.919512f,	0.353690f,	-0.171466f},
        {-0.235244f,	-0.914302f,	-0.329715f},
        {0.932168f,	0.048188f,	0.358804f},
        {-0.198448f,	-0.955562f,	0.217990f},
        {-0.657932f,	-0.695901f,	-0.287830f},
        {0.890787f,	-0.407958f,	0.200173f},
        {0.744533f,	0.476738f,	-0.467324f},
        {-0.453461f,	0.891273f,	0.002182f},
        {0.255908f,	-0.451253f,	0.854916f},
        {0.198890f,	-0.893371f,	-0.402904f},
        {-0.547378f,	0.359726f,	-0.755628f},
        {-0.706852f,	-0.057652f,	-0.705009f},
        {-0.678757f,	-0.088269f,	0.729039f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_54[][3] =
{
        {-0.978816f,	0.197688f,	-0.053272f},
        {-0.189482f,	0.981880f,	0.002855f},
        {-0.697764f,	-0.418006f,	-0.581719f},
        {-0.861976f,	0.382112f,	0.333149f},
        {-0.424487f,	-0.185969f,	-0.886130f},
        {-0.074766f,	0.237342f,	-0.968545f},
        {0.694129f,	-0.015348f,	-0.719687f},
        {-0.243619f,	0.605548f,	0.757602f},
        {-0.765873f,	0.447131f,	-0.462073f},
        {0.988439f,	0.113479f,	-0.100558f},
        {-0.895118f,	-0.054439f,	-0.442493f},
        {-0.609320f,	-0.568028f,	0.553240f},
        {0.164650f,	-0.974260f,	0.153974f},
        {0.608942f,	-0.757325f,	0.235900f},
        {0.205596f,	0.180050f,	0.961932f},
        {-0.001057f,	-0.372879f,	-0.927880f},
        {0.794380f,	-0.585372f,	-0.162175f},
        {0.840892f,	0.523046f,	-0.139011f},
        {-0.550846f,	0.246391f,	-0.797409f},
        {0.485600f,	-0.465946f,	-0.739654f},
        {0.435834f,	-0.863798f,	-0.252789f},
        {-0.177486f,	-0.970807f,	-0.161346f},
        {-0.891107f,	-0.146239f,	0.429584f},
        {0.600386f,	0.246674f,	0.760715f},
        {0.696918f,	0.405728f,	-0.591346f},
        {0.307040f,	0.576377f,	-0.757308f},
        {-0.577807f,	-0.756575f,	-0.306158f},
        {-0.044911f,	0.900257f,	0.433037f},
        {0.302911f,	0.020054f,	-0.952808f},
        {0.119753f,	0.911362f,	-0.393799f},
        {-0.247717f,	-0.712010f,	-0.657022f},
        {0.672098f,	0.647992f,	0.358317f},
        {-0.655889f,	0.241831f,	0.715072f},
        {-0.539445f,	0.743785f,	0.394693f},
        {0.940783f,	-0.273589f,	0.200191f},
        {-0.301675f,	-0.885674f,	0.352950f},
        {-0.190882f,	0.636208f,	-0.747532f},
        {-0.160287f,	-0.463593f,	0.871430f},
        {0.282277f,	0.641752f,	0.713074f},
        {0.893753f,	0.237105f,	0.380770f},
        {0.186395f,	-0.789836f,	-0.584309f},
        {0.076192f,	-0.779513f,	0.621735f},
        {0.525072f,	0.814148f,	-0.247917f},
        {-0.702298f,	0.709763f,	-0.054897f},
        {-0.946708f,	-0.321899f,	-0.011206f},
        {0.265933f,	-0.275871f,	0.923675f},
        {-0.221754f,	0.176985f,	0.958906f},
        {-0.396268f,	0.826715f,	-0.399392f},
        {0.345064f,	0.920778f,	0.181930f},
        {-0.515954f,	-0.198361f,	0.833333f},
        {0.747016f,	-0.203135f,	0.633011f},
        {0.508320f,	-0.587828f,	0.629341f},
        {0.880784f,	-0.246481f,	-0.404311f},
        {-0.705846f,	-0.699402f,	0.112328f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_55[][3] =
{
        {-0.566435f,	-0.637861f,	-0.521809f},
        {-0.356205f,	0.858169f,	-0.369681f},
        {0.223544f,	-0.950838f,	-0.214325f},
        {0.834513f,	0.363015f,	0.414497f},
        {-0.372051f,	0.597379f,	-0.710434f},
        {0.176919f,	0.623233f,	-0.761761f},
        {0.352619f,	-0.743494f,	0.568222f},
        {-0.389715f,	0.179268f,	-0.903319f},
        {0.146534f,	-0.962189f,	0.229609f},
        {-0.607484f,	-0.789134f,	-0.090727f},
        {-0.328485f,	0.078451f,	0.941246f},
        {0.881045f,	-0.106442f,	0.460902f},
        {0.488742f,	-0.320256f,	-0.811522f},
        {-0.112841f,	-0.598779f,	-0.792925f},
        {0.864253f,	-0.115701f,	-0.489572f},
        {-0.905490f,	-0.166802f,	0.390210f},
        {0.069016f,	0.262765f,	-0.962388f},
        {-0.626174f,	0.779683f,	-0.000881f},
        {0.612571f,	-0.790404f,	0.004227f},
        {-0.768968f,	0.193401f,	-0.609331f},
        {-0.101516f,	0.994663f,	0.018444f},
        {-0.875507f,	0.336070f,	0.347196f},
        {-0.193407f,	0.845126f,	0.498352f},
        {0.592300f,	0.107961f,	0.798452f},
        {0.408363f,	-0.350372f,	0.842899f},
        {-0.835129f,	-0.241308f,	-0.494297f},
        {-0.193781f,	-0.909613f,	-0.367496f},
        {-0.692503f,	0.035105f,	0.720561f},
        {0.996347f,	0.085400f,	0.000165f},
        {-0.516099f,	-0.504108f,	0.692472f},
        {0.158460f,	0.075757f,	0.984455f},
        {0.461714f,	0.886877f,	-0.016409f},
        {-0.116139f,	-0.336748f,	0.934405f},
        {-0.808713f,	0.505331f,	-0.301039f},
        {-0.610590f,	0.670264f,	0.421812f},
        {0.721001f,	-0.526967f,	0.449959f},
        {0.545060f,	0.170771f,	-0.820821f},
        {0.570123f,	0.650863f,	-0.501335f},
        {0.918172f,	-0.396143f,	0.005579f},
        {0.229143f,	0.894490f,	0.383902f},
        {-0.988282f,	0.136881f,	-0.067547f},
        {-0.456856f,	-0.266663f,	-0.848630f},
        {0.802419f,	0.596701f,	0.008436f},
        {-0.933186f,	-0.352594f,	-0.069572f},
        {0.526426f,	0.625564f,	0.575799f},
        {0.139476f,	0.904925f,	-0.402065f},
        {-0.723618f,	-0.611415f,	0.320231f},
        {0.157704f,	0.519642f,	0.839703f},
        {0.302348f,	-0.727595f,	-0.615785f},
        {-0.300401f,	-0.925252f,	0.231664f},
        {-0.099630f,	-0.728521f,	0.677739f},
        {-0.346786f,	0.500674f,	0.793136f},
        {0.075275f,	-0.191789f,	-0.978545f},
        {0.719849f,	-0.551749f,	-0.421178f},
        {0.852058f,	0.324306f,	-0.410881f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_56[][3] =
{
        {-0.483131f,	0.803130f,	-0.348664f},
        {0.158649f,	0.968744f,	-0.190695f},
        {0.282913f,	-0.111592f,	-0.952632f},
        {0.664116f,	0.320110f,	0.675633f},
        {-0.734577f,	-0.654348f,	-0.179514f},
        {0.346236f,	0.642617f,	0.683494f},
        {0.229196f,	0.933393f,	0.276127f},
        {0.625239f,	0.524374f,	-0.578021f},
        {-0.445091f,	0.008719f,	0.895443f},
        {0.167837f,	-0.363907f,	0.916189f},
        {-0.271274f,	0.622640f,	0.733982f},
        {0.696497f,	-0.153081f,	-0.701041f},
        {0.444993f,	-0.683370f,	0.578780f},
        {-0.251124f,	0.152039f,	-0.955940f},
        {0.791265f,	-0.523468f,	0.316039f},
        {-0.881715f,	-0.302437f,	-0.362093f},
        {-0.496322f,	-0.474951f,	-0.726695f},
        {-0.661607f,	0.348778f,	0.663800f},
        {-0.249307f,	-0.363842f,	0.897477f},
        {0.455838f,	-0.886223f,	0.082589f},
        {0.273095f,	0.154397f,	0.949516f},
        {0.558295f,	-0.218372f,	0.800387f},
        {0.624194f,	0.731746f,	0.273732f},
        {-0.268094f,	0.963013f,	-0.027054f},
        {0.851686f,	-0.087960f,	0.516617f},
        {-0.091707f,	0.315678f,	0.944424f},
        {0.892477f,	0.234835f,	-0.385147f},
        {0.624168f,	0.753851f,	-0.205239f},
        {-0.006501f,	-0.789160f,	0.614154f},
        {-0.344722f,	-0.788427f,	-0.509461f},
        {0.890450f,	0.437287f,	0.126015f},
        {0.173408f,	-0.571384f,	-0.802154f},
        {-0.670906f,	-0.062406f,	-0.738912f},
        {0.947711f,	-0.194530f,	-0.252988f},
        {-0.160829f,	0.878617f,	0.449628f},
        {-0.900546f,	0.309430f,	0.305401f},
        {0.023362f,	-0.974769f,	0.221992f},
        {-0.039660f,	-0.969677f,	-0.241150f},
        {-0.978137f,	0.101954f,	-0.181256f},
        {0.021576f,	0.516473f,	-0.856032f},
        {0.787208f,	-0.605608f,	-0.116373f},
        {-0.446335f,	-0.656996f,	0.607570f},
        {-0.738210f,	-0.606963f,	0.294351f},
        {0.281416f,	-0.842849f,	-0.458705f},
        {0.621818f,	-0.574676f,	-0.532061f},
        {-0.964274f,	-0.189884f,	0.184715f},
        {-0.150599f,	-0.292806f,	-0.944238f},
        {0.989972f,	0.022278f,	0.139495f},
        {0.162547f,	0.806456f,	-0.568513f},
        {-0.747124f,	0.331760f,	-0.575970f},
        {-0.419611f,	-0.905383f,	0.064866f},
        {-0.829143f,	0.545010f,	-0.124437f},
        {-0.615383f,	0.742034f,	0.265874f},
        {-0.772565f,	-0.190274f,	0.605754f},
        {-0.389987f,	0.590066f,	-0.706917f},
        {0.422317f,	0.279911f,	-0.862147f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_57[][3] =
{
        {-0.838695f,	0.347991f,	-0.418919f},
        {0.747648f,	-0.309080f,	-0.587786f},
        {0.944254f,	-0.161025f,	0.287148f},
        {-0.039841f,	-0.653672f,	0.755729f},
        {0.315409f,	-0.911010f,	0.265665f},
        {-0.459234f,	0.796341f,	-0.393630f},
        {0.057575f,	0.137139f,	0.988877f},
        {0.301143f,	0.420396f,	-0.855909f},
        {0.943385f,	0.016655f,	-0.331282f},
        {-0.689104f,	-0.724013f,	0.030691f},
        {-0.113008f,	-0.934393f,	0.337845f},
        {0.391596f,	-0.630446f,	0.670216f},
        {0.680413f,	0.716631f,	0.153225f},
        {0.095092f,	0.016338f,	-0.995334f},
        {-0.987016f,	0.086929f,	-0.135067f},
        {0.922041f,	-0.377146f,	-0.087191f},
        {-0.583888f,	-0.694585f,	-0.420270f},
        {0.360521f,	0.758342f,	-0.543086f},
        {-0.748175f,	-0.107403f,	-0.654751f},
        {0.459735f,	-0.177243f,	-0.870189f},
        {0.334424f,	-0.209789f,	0.918776f},
        {0.298686f,	0.948656f,	0.104108f},
        {-0.027247f,	0.987240f,	-0.156892f},
        {-0.400690f,	-0.472402f,	-0.785038f},
        {-0.711826f,	-0.182627f,	0.678197f},
        {0.685750f,	-0.698799f,	0.203537f},
        {-0.058492f,	0.795625f,	-0.602959f},
        {-0.448704f,	-0.694420f,	0.562535f},
        {-0.560405f,	0.694592f,	0.451097f},
        {0.377019f,	-0.702398f,	-0.603733f},
        {-0.559056f,	0.829130f,	0.000465f},
        {-0.804933f,	0.274990f,	0.525798f},
        {0.642686f,	-0.719624f,	-0.262863f},
        {0.658221f,	0.688536f,	-0.304407f},
        {0.694677f,	0.260377f,	-0.670543f},
        {-0.867776f,	0.488342f,	0.092119f},
        {-0.178859f,	0.922082f,	0.343182f},
        {-0.193888f,	0.399781f,	-0.895870f},
        {-0.367828f,	-0.054585f,	-0.928290f},
        {-0.204950f,	-0.299551f,	0.931807f},
        {-0.289157f,	-0.955005f,	-0.065979f},
        {0.074832f,	-0.492324f,	-0.867189f},
        {-0.444186f,	0.082047f,	0.892170f},
        {0.110840f,	0.531456f,	0.839803f},
        {-0.885701f,	-0.363628f,	-0.288634f},
        {0.609536f,	0.532805f,	0.587014f},
        {0.721293f,	-0.333837f,	0.606869f},
        {-0.968372f,	-0.125572f,	0.215607f},
        {0.902774f,	0.253213f,	0.347682f},
        {0.922857f,	0.367649f,	-0.114755f},
        {0.226606f,	0.806325f,	0.546342f},
        {-0.784884f,	-0.494779f,	0.373030f},
        {-0.347547f,	0.514684f,	0.783780f},
        {0.185208f,	-0.961423f,	-0.203380f},
        {0.597360f,	0.145212f,	0.788717f},
        {-0.135956f,	-0.828122f,	-0.543811f},
        {-0.562161f,	0.449396f,	-0.694276f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_58[][3] =
{
        {-0.923202f,	0.296712f,	0.244253f},
        {0.673826f,	-0.737417f,	-0.046638f},
        {-0.835583f,	-0.393571f,	0.383279f},
        {-0.656528f,	-0.747070f,	0.104198f},
        {0.270100f,	-0.374271f,	0.887111f},
        {-0.615308f,	0.148549f,	-0.774163f},
        {-0.388869f,	0.844055f,	0.369260f},
        {0.026982f,	-0.992021f,	-0.123154f},
        {-0.731964f,	0.483567f,	-0.479992f},
        {-0.290181f,	0.428853f,	0.855500f},
        {0.022057f,	-0.834521f,	-0.550535f},
        {-0.343453f,	0.917074f,	-0.202524f},
        {0.665083f,	-0.403331f,	-0.628481f},
        {0.765180f,	0.460788f,	0.449638f},
        {-0.304143f,	-0.250829f,	0.919011f},
        {-0.397072f,	-0.822088f,	-0.408051f},
        {0.072134f,	0.006776f,	0.997372f},
        {0.264528f,	-0.064400f,	-0.962225f},
        {0.127621f,	0.945402f,	-0.299880f},
        {-0.853428f,	-0.008748f,	0.521137f},
        {0.322178f,	0.380651f,	-0.866779f},
        {-0.195446f,	0.355623f,	-0.913966f},
        {0.360082f,	-0.914469f,	0.184629f},
        {-0.635301f,	-0.305274f,	-0.709366f},
        {0.458378f,	-0.779898f,	-0.426202f},
        {-0.008493f,	0.987041f,	0.160242f},
        {0.496912f,	0.747191f,	-0.441343f},
        {-0.391446f,	0.699233f,	-0.598200f},
        {0.056234f,	0.709989f,	-0.701964f},
        {-0.532057f,	-0.594039f,	0.603351f},
        {-0.239500f,	-0.514802f,	-0.823176f},
        {0.943192f,	-0.038804f,	0.329975f},
        {0.500774f,	-0.642356f,	0.580176f},
        {-0.033612f,	0.765720f,	0.642295f},
        {-0.953299f,	-0.300990f,	-0.025008f},
        {0.837383f,	-0.464955f,	0.287414f},
        {0.679314f,	-0.199686f,	0.706157f},
        {0.428522f,	0.892903f,	0.138177f},
        {0.046619f,	-0.873061f,	0.485377f},
        {-0.653208f,	0.516670f,	0.553508f},
        {0.904718f,	-0.375127f,	-0.201906f},
        {-0.918970f,	-0.062164f,	-0.389398f},
        {-0.735236f,	-0.580779f,	-0.349461f},
        {-0.123962f,	-0.631206f,	0.765645f},
        {0.750873f,	0.659157f,	-0.041254f},
        {0.243074f,	-0.501565f,	-0.830270f},
        {0.957321f,	0.285541f,	0.044750f},
        {-0.200034f,	-0.087603f,	-0.975865f},
        {-0.300237f,	-0.937413f,	0.176395f},
        {0.741179f,	0.413226f,	-0.529053f},
        {-0.553793f,	0.066089f,	0.830028f},
        {0.197035f,	0.402563f,	0.893935f},
        {0.407797f,	0.718233f,	0.563776f},
        {0.680039f,	0.023988f,	-0.732784f},
        {0.587128f,	0.204293f,	0.783291f},
        {-0.686304f,	0.726811f,	0.027078f},
        {0.951960f,	0.032425f,	-0.304502f},
        {-0.937589f,	0.313337f,	-0.150818f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_59[][3] =
{
        {-0.799568f,	0.595533f,	-0.077659f},
        {-0.981124f,	0.088573f,	-0.171900f},
        {-0.940101f,	-0.340897f,	-0.000478f},
        {0.773915f,	-0.510787f,	0.374369f},
        {0.721059f,	0.571550f,	-0.391668f},
        {0.748820f,	0.214255f,	0.627186f},
        {-0.794453f,	0.364798f,	-0.485559f},
        {-0.956868f,	0.100837f,	0.272464f},
        {0.420724f,	-0.813628f,	0.401250f},
        {0.846403f,	0.185281f,	-0.499272f},
        {0.601299f,	-0.441292f,	-0.666109f},
        {0.027611f,	0.107560f,	-0.993815f},
        {-0.419518f,	0.786481f,	0.453269f},
        {0.731351f,	0.581453f,	0.356424f},
        {0.188421f,	-0.976937f,	0.100453f},
        {-0.003065f,	-0.651857f,	0.758335f},
        {-0.142176f,	-0.889564f,	0.434122f},
        {0.914305f,	0.404745f,	0.015110f},
        {-0.355974f,	-0.934138f,	0.025853f},
        {-0.062998f,	0.822805f,	-0.564822f},
        {0.567216f,	0.058961f,	-0.821456f},
        {-0.556537f,	-0.433321f,	-0.708872f},
        {-0.357435f,	-0.800683f,	-0.480777f},
        {-0.520726f,	0.447254f,	0.727192f},
        {-0.436104f,	0.896778f,	-0.074845f},
        {0.322534f,	-0.767204f,	-0.554409f},
        {-0.296709f,	-0.178039f,	-0.938225f},
        {0.850902f,	-0.523435f,	-0.044516f},
        {-0.496419f,	0.714297f,	-0.493303f},
        {0.506821f,	-0.044850f,	0.860884f},
        {0.913623f,	-0.090273f,	0.396414f},
        {0.374491f,	0.759985f,	-0.531205f},
        {-0.057607f,	-0.603699f,	-0.795128f},
        {-0.813450f,	-0.325818f,	0.481812f},
        {-0.682132f,	-0.705571f,	0.192005f},
        {0.999276f,	-0.019294f,	-0.032796f},
        {0.304467f,	0.882409f,	0.358684f},
        {-0.347290f,	-0.253514f,	0.902840f},
        {0.562781f,	-0.809141f,	-0.169024f},
        {-0.827785f,	-0.138520f,	-0.543677f},
        {0.091382f,	0.981112f,	-0.170496f},
        {-0.248612f,	0.183425f,	0.951077f},
        {-0.787941f,	0.514732f,	0.337936f},
        {-0.102601f,	0.966145f,	0.236721f},
        {0.550279f,	0.834471f,	-0.029184f},
        {-0.188712f,	0.498579f,	-0.846053f},
        {-0.538600f,	0.206138f,	-0.816956f},
        {0.121643f,	-0.273139f,	0.954253f},
        {0.324948f,	0.430945f,	-0.841840f},
        {-0.037339f,	0.676712f,	0.735300f},
        {0.872807f,	-0.267853f,	-0.407998f},
        {-0.732466f,	-0.614925f,	-0.292164f},
        {0.008056f,	-0.955304f,	-0.295516f},
        {-0.489318f,	-0.603512f,	0.629556f},
        {-0.709817f,	0.037415f,	0.703392f},
        {0.169939f,	0.264143f,	0.949394f},
        {0.253838f,	-0.298455f,	-0.920049f},
        {0.497878f,	-0.485670f,	0.718500f},
        {0.416650f,	0.573946f,	0.704974f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_60[][3] =
{
        {-0.171264f,	0.692647f,	-0.700649f},
        {-0.906641f,	-0.204204f,	0.369192f},
        {-0.628477f,	-0.471391f,	0.618714f},
        {0.026893f,	0.661709f,	0.749278f},
        {0.791252f,	-0.541450f,	-0.284168f},
        {0.761875f,	-0.238647f,	-0.602158f},
        {-0.244151f,	0.924504f,	-0.292717f},
        {-0.455683f,	-0.219628f,	0.862622f},
        {0.809953f,	0.187931f,	-0.555570f},
        {-0.601445f,	-0.531222f,	-0.596713f},
        {0.602662f,	-0.505910f,	0.617134f},
        {0.735234f,	0.574588f,	0.359555f},
        {-0.658118f,	-0.702952f,	0.269700f},
        {-0.322569f,	-0.941752f,	0.095143f},
        {0.121025f,	0.991156f,	-0.054441f},
        {0.952021f,	-0.273078f,	0.138143f},
        {0.834762f,	0.519679f,	-0.181950f},
        {-0.520038f,	0.852940f,	0.045321f},
        {0.102734f,	-0.182650f,	-0.977796f},
        {-0.336574f,	-0.316363f,	-0.886923f},
        {0.464625f,	-0.852847f,	-0.238278f},
        {0.737609f,	-0.654461f,	0.166175f},
        {-0.961555f,	0.203465f,	0.184427f},
        {0.643371f,	0.148710f,	0.750972f},
        {0.206389f,	0.479314f,	-0.853031f},
        {-0.576074f,	0.649173f,	-0.496702f},
        {0.467242f,	-0.524351f,	-0.711858f},
        {0.192334f,	-0.737945f,	0.646873f},
        {-0.749219f,	0.146413f,	0.645937f},
        {-0.838653f,	0.530796f,	-0.122137f},
        {-0.406594f,	0.374850f,	0.833168f},
        {-0.110904f,	0.199893f,	-0.973521f},
        {0.125914f,	-0.864246f,	-0.487057f},
        {-0.973977f,	-0.052544f,	-0.220474f},
        {0.202142f,	0.212109f,	0.956111f},
        {-0.103424f,	0.941333f,	0.321242f},
        {-0.720059f,	-0.132405f,	-0.681164f},
        {0.577590f,	0.532521f,	-0.618717f},
        {-0.486579f,	0.270005f,	-0.830866f},
        {0.944046f,	0.250547f,	0.214485f},
        {-0.659077f,	-0.719411f,	-0.219240f},
        {-0.830680f,	0.252797f,	-0.496049f},
        {-0.162532f,	0.045207f,	0.985667f},
        {-0.235597f,	-0.802333f,	0.548411f},
        {0.458618f,	0.042064f,	-0.887637f},
        {-0.388796f,	0.725545f,	0.567823f},
        {0.443308f,	0.540039f,	0.715427f},
        {0.554966f,	0.826057f,	-0.098194f},
        {0.021630f,	-0.590906f,	-0.806451f},
        {0.982308f,	0.004109f,	-0.187225f},
        {-0.908148f,	-0.414989f,	-0.055239f},
        {0.382647f,	-0.877890f,	0.287908f},
        {0.257351f,	0.835225f,	-0.485974f},
        {0.838097f,	-0.124653f,	0.531089f},
        {0.353813f,	-0.241712f,	0.903544f},
        {0.070807f,	-0.996962f,	0.032464f},
        {-0.738532f,	0.567127f,	0.364607f},
        {-0.283339f,	-0.862362f,	-0.419585f},
        {0.371546f,	0.857607f,	0.355618f},
        {-0.056064f,	-0.460796f,	0.885734f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_61[][3] =
{
        {-0.534537f,	-0.178145f,	-0.826156f},
        {-0.935099f,	0.171479f,	-0.310137f},
        {-0.157646f,	-0.343364f,	-0.925877f},
        {-0.655052f,	0.341075f,	0.674222f},
        {-0.906389f,	0.363735f,	0.214839f},
        {-0.859626f,	-0.362383f,	0.360170f},
        {0.869682f,	0.439016f,	0.225650f},
        {0.044076f,	-0.761639f,	0.646500f},
        {0.504097f,	0.639631f,	0.580309f},
        {-0.174315f,	-0.924593f,	0.338735f},
        {0.470239f,	0.097791f,	0.877104f},
        {0.886910f,	0.397862f,	-0.234727f},
        {-0.368942f,	0.828775f,	-0.420731f},
        {-0.509043f,	-0.858613f,	0.060487f},
        {0.772322f,	-0.265001f,	-0.577315f},
        {0.338971f,	-0.472666f,	0.813441f},
        {0.212893f,	-0.765971f,	-0.606601f},
        {-0.574145f,	-0.657108f,	0.488433f},
        {-0.988787f,	-0.146795f,	-0.027421f},
        {0.902994f,	-0.399552f,	-0.157988f},
        {0.071413f,	0.950136f,	0.303548f},
        {0.143226f,	-0.087258f,	-0.985836f},
        {0.454610f,	-0.279590f,	-0.845671f},
        {0.002803f,	-0.989070f,	-0.147423f},
        {0.751952f,	0.174067f,	-0.635821f},
        {-0.271115f,	-0.511274f,	0.815534f},
        {-0.691878f,	0.506774f,	-0.514281f},
        {-0.839905f,	-0.226504f,	-0.493209f},
        {0.805603f,	-0.509581f,	0.302212f},
        {0.211136f,	0.960050f,	-0.183643f},
        {-0.207883f,	0.977359f,	-0.039412f},
        {-0.436463f,	0.742845f,	0.507623f},
        {0.530397f,	0.827055f,	0.186170f},
        {0.637562f,	0.739287f,	-0.216724f},
        {0.155808f,	0.366568f,	0.917252f},
        {-0.320758f,	-0.877188f,	-0.357289f},
        {0.556602f,	-0.669363f,	-0.492084f},
        {-0.159426f,	-0.677165f,	-0.718352f},
        {-0.272766f,	0.036246f,	0.961397f},
        {0.091925f,	-0.174592f,	0.980340f},
        {0.112726f,	0.800224f,	-0.589012f},
        {-0.878298f,	0.042656f,	0.476207f},
        {-0.214339f,	0.592480f,	-0.776547f},
        {0.505707f,	0.610333f,	-0.609715f},
        {0.371949f,	0.310894f,	-0.874642f},
        {0.698162f,	-0.258370f,	0.667694f},
        {-0.557550f,	0.817542f,	0.144097f},
        {-0.792412f,	0.600341f,	-0.108048f},
        {0.068799f,	0.746274f,	0.662074f},
        {-0.276373f,	0.478817f,	0.833278f},
        {0.458688f,	-0.766668f,	0.449250f},
        {-0.099150f,	0.254737f,	-0.961914f},
        {0.642549f,	-0.762288f,	-0.077767f},
        {-0.614877f,	-0.594282f,	-0.518417f},
        {-0.812150f,	-0.579142f,	-0.070759f},
        {0.304249f,	-0.949446f,	0.077359f},
        {0.987749f,	0.011943f,	-0.155595f},
        {0.753778f,	0.258828f,	0.604009f},
        {0.951986f,	-0.060742f,	0.300054f},
        {-0.571030f,	0.224102f,	-0.789749f},
        {-0.591609f,	-0.200566f,	0.780879f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_62[][3] =
{
        {-0.811014f,	0.579631f,	0.079272f},
        {-0.760155f,	-0.647770f,	0.050583f},
        {0.606500f,	-0.674323f,	-0.421244f},
        {0.618748f,	0.173566f,	0.766176f},
        {-0.297245f,	0.915280f,	0.271861f},
        {-0.760617f,	-0.478216f,	0.439056f},
        {0.286905f,	-0.904661f,	-0.315078f},
        {0.803523f,	0.542648f,	-0.244711f},
        {0.615058f,	-0.746822f,	0.252905f},
        {0.576838f,	-0.042603f,	-0.815747f},
        {0.872356f,	0.137912f,	-0.469015f},
        {0.052567f,	-0.672101f,	-0.738592f},
        {-0.057266f,	-0.509735f,	0.858424f},
        {0.397696f,	-0.458235f,	-0.794896f},
        {-0.770723f,	-0.099502f,	0.629353f},
        {-0.462956f,	-0.792812f,	0.396385f},
        {-0.814677f,	0.281819f,	-0.506833f},
        {0.190992f,	0.078922f,	0.978414f},
        {0.525763f,	0.839761f,	0.135553f},
        {-0.206131f,	0.201520f,	-0.957549f},
        {0.389410f,	-0.262859f,	0.882760f},
        {-0.215968f,	-0.070154f,	0.973877f},
        {-0.965907f,	0.217449f,	-0.140496f},
        {0.119860f,	0.991165f,	0.056794f},
        {0.133951f,	-0.780960f,	0.610048f},
        {0.523373f,	0.657071f,	0.542530f},
        {0.112452f,	0.830262f,	-0.545911f},
        {0.820469f,	-0.569268f,	-0.052578f},
        {-0.455415f,	-0.421589f,	0.784130f},
        {-0.340832f,	0.571951f,	-0.746127f},
        {0.980131f,	-0.195975f,	-0.030606f},
        {0.819514f,	0.501678f,	0.276976f},
        {-0.754944f,	0.445810f,	0.480950f},
        {0.142319f,	0.548260f,	-0.824109f},
        {-0.606549f,	0.660085f,	-0.443155f},
        {-0.966590f,	-0.254826f,	-0.027699f},
        {-0.529416f,	0.845912f,	-0.064439f},
        {0.879045f,	0.065845f,	0.472169f},
        {0.823596f,	-0.335198f,	0.457528f},
        {0.264325f,	0.503665f,	0.822468f},
        {-0.173826f,	0.939107f,	-0.296415f},
        {-0.617127f,	0.075785f,	-0.783206f},
        {-0.153588f,	0.449406f,	0.880025f},
        {-0.856098f,	-0.239368f,	-0.458038f},
        {-0.109942f,	-0.939027f,	0.325794f},
        {0.583249f,	0.480018f,	-0.655289f},
        {-0.513533f,	-0.569174f,	-0.642126f},
        {-0.406283f,	0.684799f,	0.604966f},
        {-0.219945f,	-0.971976f,	-0.082987f},
        {-0.535770f,	0.212293f,	0.817240f},
        {-0.178186f,	-0.862860f,	-0.472993f},
        {0.808011f,	-0.291467f,	-0.512020f},
        {-0.629932f,	-0.719930f,	-0.291354f},
        {0.006696f,	-0.243756f,	-0.969814f},
        {0.079505f,	0.847372f,	0.525014f},
        {0.263209f,	0.163279f,	-0.950821f},
        {0.508852f,	-0.565588f,	0.648983f},
        {0.466202f,	0.831961f,	-0.300826f},
        {0.978883f,	0.203936f,	0.014087f},
        {-0.408682f,	-0.278668f,	-0.869093f},
        {0.286249f,	-0.951990f,	0.108521f},
        {-0.956931f,	0.073246f,	0.280924f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_63[][3] =
{
        {-0.956354f,	0.180766f,	0.229589f},
        {0.274680f,	0.940498f,	-0.200038f},
        {0.792308f,	0.053462f,	0.607775f},
        {0.482460f,	-0.121962f,	0.867385f},
        {0.204363f,	0.161831f,	0.965426f},
        {0.696128f,	-0.658627f,	-0.285685f},
        {0.114647f,	-0.125686f,	-0.985423f},
        {-0.243807f,	0.863752f,	-0.441010f},
        {0.179478f,	-0.560671f,	-0.808354f},
        {-0.948350f,	-0.190342f,	0.253776f},
        {0.918048f,	0.296004f,	-0.263762f},
        {0.307197f,	0.748575f,	0.587593f},
        {0.020739f,	0.964236f,	0.264233f},
        {0.844723f,	-0.014901f,	-0.534996f},
        {-0.433900f,	0.596777f,	0.674972f},
        {-0.409006f,	-0.777484f,	-0.477737f},
        {0.535320f,	-0.125646f,	-0.835252f},
        {0.225799f,	-0.846632f,	-0.481901f},
        {-0.335778f,	0.424961f,	-0.840631f},
        {-0.481177f,	0.841614f,	0.245264f},
        {0.414626f,	-0.546404f,	0.727686f},
        {-0.753242f,	0.500938f,	0.426248f},
        {0.357545f,	0.710825f,	-0.605714f},
        {-0.582451f,	-0.390217f,	-0.713079f},
        {0.723975f,	-0.458014f,	0.515832f},
        {-0.679561f,	-0.732132f,	0.046676f},
        {0.929653f,	-0.298076f,	-0.216554f},
        {-0.230091f,	-0.117130f,	0.966094f},
        {0.676373f,	0.610376f,	-0.412262f},
        {-0.016493f,	0.704838f,	-0.709176f},
        {-0.316037f,	-0.023539f,	-0.948455f},
        {0.410955f,	-0.910355f,	-0.048680f},
        {0.543008f,	0.303364f,	-0.783016f},
        {-0.208049f,	-0.528827f,	-0.822835f},
        {-0.215605f,	0.974450f,	-0.062946f},
        {-0.618916f,	0.715727f,	-0.323541f},
        {-0.772957f,	-0.514317f,	0.371505f},
        {0.477844f,	0.849661f,	0.223030f},
        {-0.770901f,	-0.557972f,	-0.307212f},
        {0.702284f,	-0.690106f,	0.174786f},
        {0.983842f,	0.142278f,	0.108686f},
        {-0.943224f,	0.197473f,	-0.267082f},
        {0.488781f,	0.422194f,	0.763443f},
        {0.582210f,	-0.499026f,	-0.641875f},
        {0.029153f,	-0.422310f,	0.905983f},
        {-0.095934f,	-0.959320f,	-0.265522f},
        {0.142446f,	-0.792727f,	0.592700f},
        {-0.063811f,	0.712978f,	0.698277f},
        {0.108183f,	0.312438f,	-0.943758f},
        {-0.682610f,	0.400304f,	-0.611392f},
        {-0.826213f,	0.563183f,	-0.014067f},
        {0.792711f,	0.450481f,	0.410702f},
        {-0.656415f,	-0.199104f,	0.727652f},
        {0.941413f,	-0.243387f,	0.233461f},
        {0.751474f,	0.659707f,	0.008582f},
        {-0.945209f,	-0.210572f,	-0.249480f},
        {0.140812f,	-0.963974f,	0.225670f},
        {-0.291437f,	-0.821485f,	0.490129f},
        {-0.325747f,	-0.942079f,	0.079849f},
        {-0.177078f,	0.312200f,	0.933367f},
        {-0.429040f,	-0.539737f,	0.724298f},
        {-0.654219f,	0.180125f,	0.734542f},
        {-0.729568f,	-0.013250f,	-0.683780f},
};
//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 gSameDivideSphere64_64[][3] =
{
        {-0.774945f,    	0.252126f,	-0.579562f},
        {-0.254862f,    	-0.963594f,	-0.080822f},
        {-0.508779f,    	-0.064758f,	-0.858458f},
        {-0.048673f,    	-0.342229f,	0.938355f},
        {-0.008184f,    	0.533348f,	0.845857f},
        {0.199710f,	    -0.978981f,	-0.041365f},
        {0.185368f,	    -0.620745f,	0.761783f},
        {0.015548f,	    -0.930675f,	0.365515f},
        {0.560599f,	    0.418111f,	-0.714781f},
        {-0.377186f,    	0.762784f,	0.525254f},
        {0.980576f,	    0.038220f,	0.192382f},
        {-0.890919f,    	-0.133834f,	-0.433996f},
        {0.133685f,	    -0.836444f,	-0.531498f},
        {-0.656379f,    	0.463036f,	0.595621f},
        {-0.799399f,    	0.570347f,	-0.188852f},
        {0.567317f,	    -0.396926f,	0.721527f},
        {-0.538015f,    	0.838871f,	0.082681f},
        {0.377511f,	    -0.433033f,	-0.818516f},
        {0.735329f,	    -0.435078f,	-0.519614f},
        {0.615975f,	    -0.786468f,	-0.045196f},
        {0.063366f,	    0.137802f,	0.988431f},
        {0.881962f,	    0.239259f,	-0.406077f},
        {0.493611f,	    -0.751571f,	-0.437594f},
        {-0.525639f,    	-0.415716f,	-0.742216f},
        {-0.065130f,    	0.938135f,	-0.340089f},
        {0.376260f,	    0.894048f,	-0.243117f},
        {-0.243546f,    	-0.827169f,	-0.506436f},
        {-0.878682f,    	-0.433183f,	-0.200675f},
        {0.908128f,	    0.418361f,	0.016660f},
        {-0.855540f,    	-0.394511f,	0.335278f},
        {-0.029377f,    	0.395206f,	-0.918123f},
        {-0.225737f,    	0.713467f,	-0.663331f},
        {0.646283f,	    -0.036539f,	-0.762222f},
        {-0.439418f,    	-0.844415f,	0.306390f},
        {0.418552f,	    -0.801925f,	0.426299f},
        {0.758488f,	    -0.567596f,	0.320204f},
        {0.407143f,	    0.669473f,	0.621321f},
        {0.939151f,	    -0.137568f,	-0.314754f},
        {-0.419125f,    	0.307809f,	-0.854159f},
        {-0.171526f,    	0.983813f,	0.051863f},
        {0.247953f,	    0.707794f,	-0.661473f},
        {0.790248f,	    0.399825f,	0.464380f},
        {0.281648f,	    0.142899f,	-0.948818f},
        {0.019411f,	    -0.157444f,	-0.987337f},
        {-0.551217f,    	0.702604f,	-0.450008f},
        {-0.609902f,    	-0.416343f,	0.674298f},
        {-0.714256f,    	-0.696704f,	0.066650f},
        {0.409184f,	    -0.070740f,	0.909705f},
        {-0.098121f,    	-0.514981f,	-0.851567f},
        {-0.781609f,    	0.042087f,	0.622347f},
        {0.635885f,	    0.750116f,	0.181595f},
        {-0.974235f,    	-0.016684f,	0.224917f},
        {-0.274737f,    	-0.693907f,	0.665592f},
        {-0.977487f,    	0.170225f,	-0.124670f},
        {-0.838590f,    	0.490860f,	0.236270f},
        {0.539714f,	    0.297941f,	0.787363f},
        {-0.395238f,    	-0.126369f,	0.909845f},
        {0.923595f,	    -0.383368f,	0.001334f},
        {-0.600392f,    	-0.683831f,	-0.414615f},
        {-0.384483f,    	0.291761f,	0.875813f},
        {0.253176f,	    0.950198f,	0.181732f},
        {0.695145f,	    0.639526f,	-0.328299f},
        {0.020061f,	    0.849828f,	0.526678f},
        {0.830752f,	    -0.116547f,	0.544304f},
};

//------------------------------------------------------------------------------
//! @briefprivate 等分割球64のデータ
//------------------------------------------------------------------------------
static const f32 *gSameDivideSphere64Tbl[] =
{
    (f32*)gSameDivideSphere64_2  ,
    (f32*)gSameDivideSphere64_3  ,
    (f32*)gSameDivideSphere64_4  ,
    (f32*)gSameDivideSphere64_5  ,
    (f32*)gSameDivideSphere64_6  ,
    (f32*)gSameDivideSphere64_7  ,
    (f32*)gSameDivideSphere64_8  ,
    (f32*)gSameDivideSphere64_9  ,
    (f32*)gSameDivideSphere64_10 ,
    (f32*)gSameDivideSphere64_11 ,
    (f32*)gSameDivideSphere64_12 ,
    (f32*)gSameDivideSphere64_13 ,
    (f32*)gSameDivideSphere64_14 ,
    (f32*)gSameDivideSphere64_15 ,
    (f32*)gSameDivideSphere64_16 ,
    (f32*)gSameDivideSphere64_17 ,
    (f32*)gSameDivideSphere64_18 ,
    (f32*)gSameDivideSphere64_19 ,
    (f32*)gSameDivideSphere64_20 ,
    (f32*)gSameDivideSphere64_21 ,
    (f32*)gSameDivideSphere64_22 ,
    (f32*)gSameDivideSphere64_23 ,
    (f32*)gSameDivideSphere64_24 ,
    (f32*)gSameDivideSphere64_25 ,
    (f32*)gSameDivideSphere64_26 ,
    (f32*)gSameDivideSphere64_27 ,
    (f32*)gSameDivideSphere64_28 ,
    (f32*)gSameDivideSphere64_29 ,
    (f32*)gSameDivideSphere64_30 ,
    (f32*)gSameDivideSphere64_31 ,
    (f32*)gSameDivideSphere64_32 ,
    (f32*)gSameDivideSphere64_33 ,
    (f32*)gSameDivideSphere64_34 ,
    (f32*)gSameDivideSphere64_35 ,
    (f32*)gSameDivideSphere64_36 ,
    (f32*)gSameDivideSphere64_37 ,
    (f32*)gSameDivideSphere64_38 ,
    (f32*)gSameDivideSphere64_39 ,
    (f32*)gSameDivideSphere64_40 ,
    (f32*)gSameDivideSphere64_41 ,
    (f32*)gSameDivideSphere64_42 ,
    (f32*)gSameDivideSphere64_43 ,
    (f32*)gSameDivideSphere64_44 ,
    (f32*)gSameDivideSphere64_45 ,
    (f32*)gSameDivideSphere64_46 ,
    (f32*)gSameDivideSphere64_47 ,
    (f32*)gSameDivideSphere64_48 ,
    (f32*)gSameDivideSphere64_49 ,
    (f32*)gSameDivideSphere64_50 ,
    (f32*)gSameDivideSphere64_51 ,
    (f32*)gSameDivideSphere64_52 ,
    (f32*)gSameDivideSphere64_53 ,
    (f32*)gSameDivideSphere64_54 ,
    (f32*)gSameDivideSphere64_55 ,
    (f32*)gSameDivideSphere64_56 ,
    (f32*)gSameDivideSphere64_57 ,
    (f32*)gSameDivideSphere64_58 ,
    (f32*)gSameDivideSphere64_59 ,
    (f32*)gSameDivideSphere64_60 ,
    (f32*)gSameDivideSphere64_61 ,
    (f32*)gSameDivideSphere64_62 ,
    (f32*)gSameDivideSphere64_63 ,
    (f32*)gSameDivideSphere64_64 ,
};

}
}
