﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/eft2_Data.h>

namespace nw    {
namespace eft2  {

//---------------------------------------------------------------------------
//! @brief  エミッタ時間 キーフレームアニメを計算します。
//! @param[out] animV       キーフレームアニメーション結果
//! @param[out] isDstEnd    最終キーを過ぎているかどうか
//! @param[in]  animParam   アニメーションパラメータへのポインタ
//! @param[in]  time        アニメーション時刻
//---------------------------------------------------------------------------
void CalcEmitterKeyFrameAnim( nw::math::VEC3_* animV, bool* isDstEnd, nw::eft2::ResAnimEmitterKeyParamSet* animParam, const f32 time );


//---------------------------------------------------------------------------
//! @brief  エミッタ時間 キーフレームアニメを計算します。
//---------------------------------------------------------------------------
//void CalcEmitterKeyFrameAnim( nw::math::VEC3* retValue, const ResKeyFrameAnim* keyFrameAnim, f32 time );

} // namespace eft2
} // namespace nw
