﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_DW_WINDOW_LAYOUT_H_
#define NW_DW_WINDOW_LAYOUT_H_

#include <types.h>
#include <nw/dw/window/dw_Window.h>
#include <nw/ut/ut_FileStream.h>

namespace nw {
namespace internal {
namespace dw {

class WindowManager;

class WindowLayoutBase
{
  public:
    WindowLayoutBase() : m_ValidFlag( false ), m_WindowStateCount(0) {}
    virtual ~WindowLayoutBase() {}

    bool Constract( const WindowManager& manager );
    bool RestoreLayout( WindowManager* manager ) const;

    bool Serialize( ut::FileStream* fileStream ) const;
    bool Deserialize( ut::FileStream* fileStream );

    void Dump() const;

  protected:
    struct WindowState
    {
        char title[ Window::TITLE_LEN_MAX ];
        nw::math::Vector2 pos;
        nw::math::Vector2 size;
        bool visible;
        bool shade;
        int order;
        int zorder;
    };

    virtual WindowState* GetWindowState( int index ) = 0;
    virtual const WindowState* GetWindowState( int index ) const = 0;

  private:
    static const u32 FILE_HEADER_SIGNATURE = NW_UT_MAKE_SIGWORD( 'R','D','W','L' );
    static const u32 BLOCK_KIND = NW_UT_MAKE_SIGWORD( 'W','N','D','S' ); // WindowState
    static const u32 FILE_VERSION = NW_UT_MAKE_VERSION( 1, 0, 0, 0 );

    struct FileHeader
    {
        ut::BinaryFileHeader common;
        u32 reserved[4];
    };

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    #pragma warning(push)
    #pragma warning(disable: 4200)
#endif

    struct DataBlock
    {
        ut::BinaryBlockHeader blockHeader;
        u32 windowCount;
        u32 reserved[5];
        u32 windowStateOffset[0];
    };

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
    // TODO: NintendoSdk 対応後、このコメントを削除してください。
    #pragma warning(pop)
#endif
    struct WindowStateData
    {
        char title[ 64 ];
        f32 x;
        f32 y;
        f32 width;
        f32 height;
        s32 order;
        s32 zorder;
        u8 visible;
        u8 shade;
        u8 padding[2];
        u32 reserved[9];
    };

    static Window* FindWindow( WindowList& windowList, const char* windowTitle );

    bool m_ValidFlag;
    int m_WindowStateCount;
};

template< int MAX_WINDOW_COUNT >
class FixedSizeWindowLayout : public WindowLayoutBase
{
  private:
    virtual WindowState* GetWindowState( int index ) {
        if ( index >= MAX_WINDOW_COUNT ) return NULL;
        return &m_WindowStateArray[index];
    }
    virtual const WindowState* GetWindowState( int index ) const {
        if ( index >= MAX_WINDOW_COUNT ) return NULL;
        return &m_WindowStateArray[index];
    }

    WindowState m_WindowStateArray[MAX_WINDOW_COUNT];
};

} // namespace nw::internal::dw
} // namespace nw::internal
} // namespace nw

#endif // NW_DW_WINDOW_LAYOUT_H_
