﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Color.h>

namespace nw {
namespace internal {
namespace dw {

struct UIElementRenderArgs
{
    UIElementRenderArgs() : isBordered(false) { }

    UIElementRenderArgs& SetIsBordered(bool value);
    UIElementRenderArgs& SetBorderColor(const nw::ut::Color4f& value);
    UIElementRenderArgs& SetBackgroundColor(const nw::ut::Color4f& value);
    UIElementRenderArgs& SetBackgroundColor(const nw::ut::Color4f& value0, const nw::ut::Color4f& value1);

    bool isBordered;
    nw::ut::Color4f borderColor;
    nw::ut::Color4f backgroundColor0;
    nw::ut::Color4f backgroundColor1;
};

} // dw
} // internal
} // nw
