﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_styles/StyleT.h>

namespace nw {
namespace internal {
namespace dw {

template<class TUIElement>
bool StyleT<TUIElement>::CanApply(UIElement& element)
{
    return CanApplyInternal(reinterpret_cast<TUIElement&>(element));
}

template<class TUIElement>
void StyleT<TUIElement>::Apply(UIElement& element)
{
    ApplyInternal(reinterpret_cast<TUIElement&>(element));
}


} // dw
} // internal
} // nw
