﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace internal {
namespace dw {

class Separator : public UIElement
{
private:
    typedef UIElement Base;

    //! ライン幅は 1 固定です。
    static const u32 LINE_WIDTH = 1;

public:
    Separator();

    Orientation GetOrientation() const;
    void SetOrientation(Orientation value);

protected:
    /*override*/ const nw::math::Vector2 OnMeasure(UIRenderer& renderer) const;
    /*override*/ void OnRender(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const;

    /*override*/ bool CanAlignHorizontal(const UIElement& element) const;
    /*override*/ bool CanAlignVertical(const UIElement& element) const;

private:
    nw::math::Vector2 MeasureByVertical() const;
    nw::math::Vector2 MeasureByHorizontal() const;

    void RenderByHorizontal(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const;
    void RenderByVertical(const UIElementTreeContext& context, UIRenderer& renderer, UIElementRenderArgs& args) const;

private:
    Orientation m_Orientation;
};

} // dw
} // internal
} // nw
