﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_StackPanel.h>
#include <nw/dw/control/dw_FixedUIElementList.h>

namespace nw {
namespace internal {
namespace dw {

template<int TItemCount>
class FixedStackPanel : public StackPanel
{
public:
    FixedStackPanel()
    {
        SetContents(m_Contents);
        NW_ASSERT(GetContents().GetCount() == 0);
    }

    FixedStackPanel(const UIElement** ppItems, int count) : m_Contents(ppItems, count)
    {
        SetContents(m_Contents);
        NW_ASSERT(GetContents().GetCount() == count);
    }

    virtual ~FixedStackPanel() { }

private:
    FixedUIElementList<TItemCount> m_Contents;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
private:
    static const u32 DEBUG_TEXT_LENGTH = 32;

public:
    virtual const char* ToString() const
    {
        ut::snprintf(const_cast<char*>(m_DebugText), sizeof(m_DebugText), sizeof(m_DebugText) - 1, "FixedStackPanel<%d>", TItemCount);
        return m_DebugText;
    }

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];
#endif
};

} // dw
} // internal
} // nw
