﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nw {
namespace internal {
namespace dw {

class FileBrowserFilterEventArgs
{
public:
    FileBrowserFilterEventArgs() :
        m_pName(NULL),
        m_IsDirectory(false),
        m_IsCanceled(false)
    {
    }

    explicit FileBrowserFilterEventArgs(const char* pName, bool isDirectory) :
        m_pName(pName),
        m_IsDirectory(isDirectory),
        m_IsCanceled(false)
    {
    }

public:
    const char* GetName() const
    {
        return m_pName;
    }

    bool GetIsDirectory() const
    {
        return m_IsDirectory;
    }

    bool GetIsCanceled() const
    {
        return m_IsCanceled;
    }

    void SetIsCanceled(bool value)
    {
        m_IsCanceled = value;
    }

private:
    const char* m_pName;
    bool m_IsDirectory;
    bool m_IsCanceled;
};

} // dw
} // internal
} // nw
