﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Delegate.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedListBox.h>
#include <nw/dw/control/dw_FileBrowserEntry.h>
#include <nw/dw/control/dw_FileBrowserFilterEvent.h>
#include <nw/dw/control/dw_FileBrowserExecuteEvent.h>

namespace nw {
namespace internal {
namespace dw {

//---------------------------------------------------------------------------
//! @brief  ディレクトリ、ファイルの一覧を表示する UI 要素です。
//---------------------------------------------------------------------------
class FileBrowser : public UIElement
{
public:
    typedef ut::IDelegate1<void, FileBrowserFilterEventArgs&> IFilterEventHandler;
    typedef ut::IDelegate1<void, FileBrowserExecuteEventArgs&> IExecuteEventHandler;

protected:
    static const u32 MAX_FILE_PATH = 256;
    static const u32 MAX_FILE_ENTRIES = 1024;
    static const char PATH_SEPARATOR = '/';
    static const char* PARENT_DIRECTORY_PATH;

private:
    typedef UIElement Base;

public:
    FileBrowser();

    const char* GetCurrentDirectoryPath() const;
    void SetCurrentDirectoryPath(const char* value);

    const char* GetCurrentFilePath() const;

    IFilterEventHandler* GetFilterEventHandler() const;
    void SetFilterEventHandler(IFilterEventHandler* value);

    IExecuteEventHandler* GetExecuteEventHandler() const;
    void SetExecuteEventHandler(IExecuteEventHandler* value);

    void SelectFileEntry(const char* pText);
    bool UpdateFileEntries();

protected:
    virtual bool BuildFileEntries(const char* pPath) = 0;
    virtual bool CanMoveParentDirectory(const char* pPath) = 0;

    bool AddFileEntry(const char* pText, bool isDirectory);
    void MoveDirectory(const char* pName);

    /* override */ bool OnUpdatePointerInput(const nw::internal::dw::Inputs& inputs);
    /* override */ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

private:
    bool AddFileEntryImpl(const char* pText, bool isDirectory);
    void ClearFileEntries();
    FileBrowserEntry* GetSelectedEntryFirst() const;
    void ExecuteFileEntry(FileBrowserEntry& entry);

    const char* GetEntryName(const char* pPath) const;
    bool MakeParentDirectoryPath(char* pPath) const;
    void UpdateCurrentFilePath();

    void OnFileEntrySelectionChanged();

private:
    FixedUIElementList<1> m_Contents;

    char m_CurrentDirectoryPath[MAX_FILE_PATH + 1];
    char m_CurrentFilePath[MAX_FILE_PATH + 1];
    FixedListBox<MAX_FILE_ENTRIES> m_Entries;
    FileBrowserEntry m_EntryElements[MAX_FILE_ENTRIES];

    ListBox::SelectionChangedEventHandler m_FileEntrySelectionChangedEventHandler;

    IFilterEventHandler* m_pFilterEventHandler;
    IExecuteEventHandler* m_pExecuteEventHandler;

#if defined(NW_DEBUG) || defined(NW_DEVELOP)
public:
    /*override*/ const char* ToString() const
    {
        return "FileBrowser";
    }
#endif
};

} // dw
} // internal
} // nw
