﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef DW_ENUMS_H_
#define DW_ENUMS_H_

#include <nw/types.h>

namespace nw {
namespace internal {
namespace dw {

//! @details :private
class IEnums
{
public:
    virtual ~IEnums(){}
    virtual u32         get_idx( s32 value )        const = 0;
    virtual s32         value( u32 idx )            const = 0;
    virtual const char* name( u32 idx )             const = 0;
    virtual const char* name_by_value( s32 val )    const = 0;
    virtual u32         size()                      const = 0;
};


} // dw
} // internal
} // nw

#endif //  DW_ENUMS_H_
